/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.extraction.MapBasedLookupExtractorTest;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.junit.Assert;
import org.junit.Test;

public class MapLookupExtractorTest
extends MapBasedLookupExtractorTest {
    @Override
    protected LookupExtractor makeLookupExtractor(Map<String, String> map) {
        return new MapLookupExtractor(map, false);
    }

    @Test
    public void test_getCacheKey() {
        LookupExtractor fn = this.makeLookupExtractor(this.simpleLookupMap);
        MapLookupExtractor fn2 = new MapLookupExtractor((Map)ImmutableMap.copyOf((Map)this.simpleLookupMap), false);
        Assert.assertArrayEquals((byte[])fn.getCacheKey(), (byte[])fn2.getCacheKey());
        MapLookupExtractor fn3 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo2", (Object)"bar"), false);
        Assert.assertFalse((boolean)Arrays.equals(fn.getCacheKey(), fn3.getCacheKey()));
        MapLookupExtractor fn4 = new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar2"), false);
        Assert.assertFalse((boolean)Arrays.equals(fn.getCacheKey(), fn4.getCacheKey()));
    }

    @Test
    public void test_estimateHeapFootprint_static() {
        Assert.assertEquals((long)0L, (long)MapLookupExtractor.estimateHeapFootprint(Collections.emptyMap().entrySet()));
        Assert.assertEquals((long)388L, (long)MapLookupExtractor.estimateHeapFootprint((Iterable)ImmutableMap.copyOf((Map)this.simpleLookupMap).entrySet()));
    }

    @Test
    public void test_estimateHeapFootprint_staticNullKeysAndValues() {
        HashMap<String, String> mapWithNullKeysAndNullValues = new HashMap<String, String>();
        mapWithNullKeysAndNullValues.put("foo", "bar");
        mapWithNullKeysAndNullValues.put("foo2", null);
        Assert.assertEquals((long)180L, (long)MapLookupExtractor.estimateHeapFootprint(mapWithNullKeysAndNullValues.entrySet()));
    }

    @Test
    public void test_estimateHeapFootprint_staticNonStringKeysAndValues() {
        HashMap<Long, Number> mapWithNonStringKeysAndValues = new HashMap<Long, Number>();
        mapWithNonStringKeysAndValues.put(3L, 1);
        mapWithNonStringKeysAndValues.put(4L, 3.2);
        Assert.assertEquals((long)160L, (long)MapLookupExtractor.estimateHeapFootprint(mapWithNonStringKeysAndValues.entrySet()));
    }

    @Test
    public void test_equalsAndHashCode() {
        EqualsVerifier.forClass(MapLookupExtractor.class).usingGetClass().withNonnullFields(new String[]{"map"}).verify();
    }
}

