/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

public class LikeDimFilterTest
extends InitializedNullHandlingTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);

    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        DimFilter filter2 = (DimFilter)objectMapper.readValue(objectMapper.writeValueAsString((Object)filter), DimFilter.class);
        Assert.assertEquals((Object)filter, (Object)filter2);
    }

    @Test
    public void testGetCacheKey() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertArrayEquals((byte[])filter.getCacheKey(), (byte[])filter2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(filter.getCacheKey(), filter3.getCacheKey()));
    }

    @Test
    public void testEqualsAndHashCode() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertEquals((Object)filter, (Object)filter2);
        Assert.assertNotEquals((Object)filter, (Object)filter3);
        Assert.assertEquals((long)filter.hashCode(), (long)filter2.hashCode());
        Assert.assertNotEquals((long)filter.hashCode(), (long)filter3.hashCode());
    }

    @Test
    public void testGetRequiredColumns() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertEquals((Object)filter.getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"foo"}));
    }

    @Test
    public void testEqualsContractForExtractionFnDruidPredicateFactory() {
        EqualsVerifier.forClass(LikeDimFilter.LikeMatcher.PatternDruidPredicateFactory.class).withNonnullFields(new String[]{"pattern"}).usingGetClass().verify();
    }

    @Test
    public void test_LikeMatcher_equals() {
        EqualsVerifier.forClass(LikeDimFilter.LikeMatcher.class).usingGetClass().withNonnullFields(new String[]{"suffixMatch", "prefix", "pattern"}).withIgnoredFields(new String[]{"likePattern"}).verify();
    }

    @Test
    public void testPrefixMatchUsesRangeIndex() {
        Filter likeFilter = new LikeDimFilter("dim0", "f%", null, null, null).toFilter();
        ColumnIndexSelector indexSelector = (ColumnIndexSelector)Mockito.mock(ColumnIndexSelector.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)Mockito.mock(ColumnIndexSupplier.class);
        LexicographicalRangeIndexes rangeIndex = (LexicographicalRangeIndexes)Mockito.mock(LexicographicalRangeIndexes.class);
        BitmapColumnIndex bitmapColumnIndex = (BitmapColumnIndex)Mockito.mock(BitmapColumnIndex.class);
        Mockito.when((Object)indexSelector.getIndexSupplier("dim0")).thenReturn((Object)indexSupplier);
        Mockito.when((Object)((LexicographicalRangeIndexes)indexSupplier.as(LexicographicalRangeIndexes.class))).thenReturn((Object)rangeIndex);
        Mockito.when((Object)rangeIndex.forRange("f", false, "f\uffff", false)).thenReturn((Object)bitmapColumnIndex);
        BitmapColumnIndex retVal = likeFilter.getBitmapColumnIndex(indexSelector);
        Assert.assertSame((String)"likeFilter returns the intended bitmapColumnIndex", (Object)bitmapColumnIndex, (Object)retVal);
    }

    @Test
    public void testExactMatchUsesValueIndex() {
        Filter likeFilter = new LikeDimFilter("dim0", "f", null, null, null).toFilter();
        ColumnIndexSelector indexSelector = (ColumnIndexSelector)Mockito.mock(ColumnIndexSelector.class);
        ColumnIndexSupplier indexSupplier = (ColumnIndexSupplier)Mockito.mock(ColumnIndexSupplier.class);
        StringValueSetIndexes valueIndex = (StringValueSetIndexes)Mockito.mock(StringValueSetIndexes.class);
        BitmapColumnIndex bitmapColumnIndex = (BitmapColumnIndex)Mockito.mock(BitmapColumnIndex.class);
        Mockito.when((Object)indexSelector.getIndexSupplier("dim0")).thenReturn((Object)indexSupplier);
        Mockito.when((Object)((StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class))).thenReturn((Object)valueIndex);
        Mockito.when((Object)valueIndex.forValue("f")).thenReturn((Object)bitmapColumnIndex);
        BitmapColumnIndex retVal = likeFilter.getBitmapColumnIndex(indexSelector);
        Assert.assertSame((String)"likeFilter returns the intended bitmapColumnIndex", (Object)bitmapColumnIndex, (Object)retVal);
    }

    @Test
    public void testPatternCompilation() {
        this.assertCompilation("", ":[^$]");
        this.assertCompilation("a", "a:[^a$]");
        this.assertCompilation("abc", "abc:[^abc$]");
        this.assertCompilation("a%", "a:[^a]");
        this.assertCompilation("%a", ":[a$]");
        this.assertCompilation("%a%", ":[a]");
        this.assertCompilation("%_a", ":[.a$]");
        this.assertCompilation("_%a", ":[^., a$]");
        this.assertCompilation("_%_a", ":[^., .a$]");
        this.assertCompilation("abc%", "abc:[^abc]");
        this.assertCompilation("a%b", "a:[^a, b$]");
        this.assertCompilation("abc%x", "abc:[^abc, x$]");
        this.assertCompilation("abc%xyz", "abc:[^abc, xyz$]");
        this.assertCompilation("____", ":[^....$]");
        this.assertCompilation("%%%%", ":[]");
        this.assertCompilation("%_%_%%__", ":[., ., ..$]");
        this.assertCompilation("%_%a_%bc%_d_", ":[., a., bc, .d.$]");
        this.assertCompilation("%1 _ 5%6", ":[1 . 5, 6$]");
        this.assertCompilation("\\%_%a_\\%b\\\\c\\___%_%_d_w%x_y_z", "%:[^\\u0025., a.\\u0025b\\u005Cc_.., ., .d.w, x.y.z$]");
    }

    @Test
    public void testPatternEmpty() {
        this.assertMatch("", null, DruidPredicateMatch.UNKNOWN);
        this.assertMatch("", "", DruidPredicateMatch.TRUE);
        this.assertMatch("", "a", DruidPredicateMatch.FALSE);
        this.assertMatch("", "This is a test!", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternExactMatch() {
        this.assertMatch("a\nb", "a\nb", DruidPredicateMatch.TRUE);
        this.assertMatch("a\nb", "a\nc", DruidPredicateMatch.FALSE);
        this.assertMatch("This is a test", "This is a test", DruidPredicateMatch.TRUE);
        this.assertMatch("This is a test", "this is a test", DruidPredicateMatch.FALSE);
        this.assertMatch("This is a test", "This is a tes", DruidPredicateMatch.FALSE);
        this.assertMatch("This is a test", "his is a test", DruidPredicateMatch.FALSE);
        this.assertMatch("This \\%is a\\_test", "This %is a_test", DruidPredicateMatch.TRUE);
        this.assertMatch("This \\%is a\\_test", "This \\%is a_test", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternTrickySuffixes() {
        this.assertMatch("%xyz", "abcxyzxyz", DruidPredicateMatch.TRUE);
        this.assertMatch("ab%bc", "abc", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternOnlySpecial() {
        this.assertMatch("%", null, DruidPredicateMatch.UNKNOWN);
        this.assertMatch("%", "", DruidPredicateMatch.TRUE);
        this.assertMatch("%", "abcxyzxyz", DruidPredicateMatch.TRUE);
        this.assertMatch("_", null, DruidPredicateMatch.UNKNOWN);
        this.assertMatch("_", "", DruidPredicateMatch.FALSE);
        this.assertMatch("_", "a", DruidPredicateMatch.TRUE);
        this.assertMatch("_", "ab", DruidPredicateMatch.FALSE);
        this.assertMatch("____", "abc", DruidPredicateMatch.FALSE);
        this.assertMatch("____", "abcd", DruidPredicateMatch.TRUE);
        this.assertMatch("____", "abcde", DruidPredicateMatch.FALSE);
        this.assertMatch("%____", "abcde", DruidPredicateMatch.TRUE);
        this.assertMatch("%____", "abcd", DruidPredicateMatch.TRUE);
        this.assertMatch("%____", "abc", DruidPredicateMatch.FALSE);
        this.assertMatch("__%_%%_", "abc", DruidPredicateMatch.FALSE);
        this.assertMatch("__%_%%_", "abcd", DruidPredicateMatch.TRUE);
        this.assertMatch("__%_%%_", "abcdxyz", DruidPredicateMatch.TRUE);
        this.assertMatch("%__%_%%_%", "abc", DruidPredicateMatch.FALSE);
        this.assertMatch("%__%_%%_%", "abcd", DruidPredicateMatch.TRUE);
        this.assertMatch("%__%_%%_%", "abcdxyz", DruidPredicateMatch.TRUE);
    }

    @Test
    public void testPatternTrailingWildcard() {
        this.assertMatch("ab%", "abc", DruidPredicateMatch.TRUE);
        this.assertMatch("ab%", "ab", DruidPredicateMatch.TRUE);
        this.assertMatch("ab%", "a", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternLeadingWildcard() {
        this.assertMatch("%yz", "xyz", DruidPredicateMatch.TRUE);
        this.assertMatch("%yz", "yz", DruidPredicateMatch.TRUE);
        this.assertMatch("%yz", "z", DruidPredicateMatch.FALSE);
        this.assertMatch("%yz", "wxyz", DruidPredicateMatch.TRUE);
        this.assertMatch("%yz", "xyza", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternTrailingAny() {
        this.assertMatch("ab_", "abc", DruidPredicateMatch.TRUE);
        this.assertMatch("ab_", "ab", DruidPredicateMatch.FALSE);
        this.assertMatch("ab_", "abcd", DruidPredicateMatch.FALSE);
        this.assertMatch("ab_", "xabc", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternLeadingAny() {
        this.assertMatch("_yz", "xyz", DruidPredicateMatch.TRUE);
        this.assertMatch("_yz", "yz", DruidPredicateMatch.FALSE);
        this.assertMatch("_yz", "wxyz", DruidPredicateMatch.FALSE);
        this.assertMatch("_yz", "xyza", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternLeadingAndTrailing() {
        this.assertMatch("_jkl_", "jkl", DruidPredicateMatch.FALSE);
        this.assertMatch("_jkl_", "ijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("_jkl_", "ijklmn", DruidPredicateMatch.FALSE);
        this.assertMatch("_jkl_", "hijklm", DruidPredicateMatch.FALSE);
        this.assertMatch("%jkl%", "jkl", DruidPredicateMatch.TRUE);
        this.assertMatch("%jkl%", "ijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("%jkl%", "ijklmn", DruidPredicateMatch.TRUE);
        this.assertMatch("%jkl%", "hijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("_jkl%", "jkl", DruidPredicateMatch.FALSE);
        this.assertMatch("_jkl%", "ijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("_jkl%", "ijklmn", DruidPredicateMatch.TRUE);
        this.assertMatch("_jkl%", "hijklm", DruidPredicateMatch.FALSE);
        this.assertMatch("_jkl%", "hijklmn", DruidPredicateMatch.FALSE);
        this.assertMatch("%jkl_", "jkl", DruidPredicateMatch.FALSE);
        this.assertMatch("%jkl_", "ijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("%jkl_", "ijklmn", DruidPredicateMatch.FALSE);
        this.assertMatch("%jkl_", "hijklm", DruidPredicateMatch.TRUE);
        this.assertMatch("%jkl_", "hijklmn", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternSuffixWithManyParts() {
        this.assertMatch("%ba_", "foo bar", DruidPredicateMatch.TRUE);
        this.assertMatch("%ba_", "foo bar daz", DruidPredicateMatch.FALSE);
        this.assertMatch("%ba_%", "foo bar baz", DruidPredicateMatch.TRUE);
        this.assertMatch("a%b_d_", "abcde", DruidPredicateMatch.TRUE);
        this.assertMatch("a%b_d_", "abcdexyzbcde", DruidPredicateMatch.TRUE);
        this.assertMatch("%b_d_", "abcde", DruidPredicateMatch.TRUE);
        this.assertMatch("%b_d_", "abcdexyzbcde", DruidPredicateMatch.TRUE);
        this.assertMatch("%b_d_", "abcdexyzbcdef", DruidPredicateMatch.FALSE);
        this.assertMatch("%b_d_", "abcdexyzbcd", DruidPredicateMatch.FALSE);
        this.assertMatch("%z%_b_d_", "abcdexyzabcde", DruidPredicateMatch.TRUE);
        this.assertMatch("%z%_b_d_", "abcdexyzbcde", DruidPredicateMatch.FALSE);
        this.assertMatch("%z%_b_d_", "abcdexybcde", DruidPredicateMatch.FALSE);
        this.assertMatch("%z%_b_d_", "abcdexbcde", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternNoWildcards() {
        this.assertMatch("a_c_e_", "abcdef", DruidPredicateMatch.TRUE);
        this.assertMatch("a_c_e_", "abcde", DruidPredicateMatch.FALSE);
        this.assertMatch("x_c_e_", "abcdef", DruidPredicateMatch.FALSE);
        this.assertMatch("xa_c_e_", "abcdef", DruidPredicateMatch.FALSE);
        this.assertMatch("a_c_e_x", "abcde", DruidPredicateMatch.FALSE);
    }

    @Test
    public void testPatternFindsCorrectMiddleMatch() {
        this.assertMatch("%km%z", "akmz", DruidPredicateMatch.TRUE);
        this.assertMatch("%km%z", "akkmz", DruidPredicateMatch.TRUE);
        this.assertMatch("%xy%yz", "xyz", DruidPredicateMatch.FALSE);
        this.assertMatch("%xy%yz", "xyyz", DruidPredicateMatch.TRUE);
        this.assertMatch("%1 _ 5%6", "1 2 3 1 4 5 6", DruidPredicateMatch.TRUE);
        this.assertMatch("1 _ 5%6", "1 2 3 1 4 5 6", DruidPredicateMatch.FALSE);
    }

    private void assertCompilation(String pattern, String expected) {
        LikeDimFilter.LikeMatcher matcher = LikeDimFilter.LikeMatcher.from((String)pattern, (Character)Character.valueOf('\\'));
        Assert.assertEquals((Object)(pattern + " => " + expected), (Object)matcher.describeCompilation());
    }

    private void assertMatch(String pattern, String value, DruidPredicateMatch expected) {
        LikeDimFilter.LikeMatcher matcher = LikeDimFilter.LikeMatcher.from((String)pattern, (Character)Character.valueOf('\\'));
        Assert.assertEquals((String)(matcher + " matches " + value), (Object)expected, (Object)matcher.matches(value));
    }
}

