/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterTestUtils;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.FilterTestUtils;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.TrueFilter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class OrDimFilterTest
extends InitializedNullHandlingTest {
    @Test
    public void testToFilterWithDuplicateFilters() {
        OrDimFilter dimFilter = DimFilterTestUtils.or(new DimFilter[]{DimFilterTestUtils.and(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), DimFilterTestUtils.selector("col2", "2")}), DimFilterTestUtils.and(new DimFilter[]{DimFilterTestUtils.selector("col2", "2"), DimFilterTestUtils.selector("col1", "1")}), DimFilterTestUtils.selector("col3", "3")});
        OrFilter expected = FilterTestUtils.or(new Filter[]{FilterTestUtils.and(new Filter[]{FilterTestUtils.selector("col1", "1"), FilterTestUtils.selector("col2", "2")}), FilterTestUtils.selector("col3", "3")});
        Assert.assertEquals((Object)expected, (Object)dimFilter.toFilter());
    }

    @Test
    public void testToFilterShortCircuitWithTrueFilter() {
        OrDimFilter filter = DimFilterTestUtils.or(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), TrueDimFilter.instance()});
        Assert.assertTrue((boolean)(filter.toFilter() instanceof TrueFilter));
    }

    @Test
    public void testToFilterOringFalseFilters() {
        OrDimFilter filter = DimFilterTestUtils.or(new DimFilter[]{FalseDimFilter.instance(), FalseDimFilter.instance()});
        Assert.assertSame((Object)FalseFilter.instance(), (Object)filter.toFilter());
    }

    @Test
    public void testOptimizeOrOfSingleFilterUnwrapOr() {
        SelectorDimFilter expected = DimFilterTestUtils.selector("col1", "1");
        OrDimFilter filter = DimFilterTestUtils.or(new DimFilter[]{expected});
        Assert.assertEquals((Object)expected.toFilter(), (Object)filter.toFilter());
    }

    @Test
    public void testOptimizeOrOfMultipleFiltersReturningAsItIs() {
        OrDimFilter filter = DimFilterTestUtils.or(new DimFilter[]{DimFilterTestUtils.selector("col1", "1"), DimFilterTestUtils.selector("col1", "2")});
        Assert.assertEquals((Object)filter.toFilter(), (Object)filter.toFilter());
    }
}

