/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.collection;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.groupby.epinephelinae.collection.HashTableUtils;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryOpenHashTable;
import org.junit.Assert;
import org.junit.Test;

public class MemoryOpenHashTableTest {
    @Test
    public void testMemoryNeeded() {
        Assert.assertEquals((long)512L, (long)MemoryOpenHashTable.memoryNeeded((int)128, (int)4));
    }

    @Test
    public void testEmptyTable() {
        MemoryOpenHashTable table = MemoryOpenHashTableTest.createTable(8, 0.75, 4, 4);
        Assert.assertEquals((long)8L, (long)table.numBuckets());
        Assert.assertEquals((long)72L, (long)table.memory().getCapacity());
        Assert.assertEquals((long)9L, (long)table.bucketSize());
        MemoryOpenHashTableTest.assertEqualsMap((Map<ByteBuffer, ByteBuffer>)ImmutableMap.of(), table);
    }

    @Test
    public void testInsertRepeatedKeys() {
        MemoryOpenHashTable table = MemoryOpenHashTableTest.createTable(8, 0.7, 4, 4);
        WritableMemory keyMemory = WritableMemory.allocate((int)4);
        int[] keys = new int[]{0, 1, 2};
        for (int i = 0; i < 3; ++i) {
            for (int key : keys) {
                int valuePosition;
                keyMemory.putInt(0L, key);
                int bucket = table.findBucket(HashTableUtils.hashMemory((Memory)keyMemory, (long)0L, (int)4), (Memory)keyMemory, 0);
                if (bucket < 0) {
                    Assert.assertTrue((boolean)table.canInsertNewBucket());
                    bucket = -(bucket + 1);
                    table.initBucket(bucket, (Memory)keyMemory, 0);
                    valuePosition = table.bucketMemoryPosition(bucket) + table.bucketValueOffset();
                    table.memory().putInt((long)valuePosition, 0);
                }
                valuePosition = table.bucketMemoryPosition(bucket) + table.bucketValueOffset();
                table.memory().putInt((long)valuePosition, table.memory().getInt((long)valuePosition) + key);
            }
        }
        HashMap<ByteBuffer, ByteBuffer> expectedMap = new HashMap<ByteBuffer, ByteBuffer>();
        expectedMap.put(MemoryOpenHashTableTest.expectedKey(0), MemoryOpenHashTableTest.expectedValue(0));
        expectedMap.put(MemoryOpenHashTableTest.expectedKey(1), MemoryOpenHashTableTest.expectedValue(3));
        expectedMap.put(MemoryOpenHashTableTest.expectedKey(2), MemoryOpenHashTableTest.expectedValue(6));
        MemoryOpenHashTableTest.assertEqualsMap(expectedMap, table);
    }

    @Test
    public void testInsertDifferentKeysUntilFull() {
        MemoryOpenHashTable table = MemoryOpenHashTableTest.createTable(256, 0.999, 4, 4);
        HashMap<ByteBuffer, ByteBuffer> expectedMap = new HashMap<ByteBuffer, ByteBuffer>();
        int key = 0;
        while (table.canInsertNewBucket()) {
            int value = Integer.MAX_VALUE - key;
            int bucket = MemoryOpenHashTableTest.findAndInitBucket(table, key);
            Assert.assertTrue((String)("bucket < 0 for key " + key), (bucket < 0 ? 1 : 0) != 0);
            MemoryOpenHashTableTest.writeValueToBucket(table, -(bucket + 1), value);
            expectedMap.put(MemoryOpenHashTableTest.expectedKey(key), MemoryOpenHashTableTest.expectedValue(value));
            key += 7;
        }
        Assert.assertEquals((String)"expected size", (long)255L, (long)table.size());
        MemoryOpenHashTableTest.assertEqualsMap(expectedMap, table);
    }

    @Test
    public void testCopyTo() {
        MemoryOpenHashTable table1 = MemoryOpenHashTableTest.createTable(64, 0.7, 4, 4);
        MemoryOpenHashTable table2 = MemoryOpenHashTableTest.createTable(128, 0.7, 4, 4);
        Int2IntOpenHashMap expectedMap = new Int2IntOpenHashMap();
        expectedMap.put(0, 1);
        expectedMap.put(-1, 2);
        expectedMap.put(111, 123);
        expectedMap.put(Integer.MAX_VALUE, Integer.MIN_VALUE);
        expectedMap.put(Integer.MIN_VALUE, Integer.MAX_VALUE);
        for (Int2IntMap.Entry entry2 : expectedMap.int2IntEntrySet()) {
            int bucket = MemoryOpenHashTableTest.findAndInitBucket(table1, entry2.getIntKey());
            Assert.assertTrue((String)("bucket < 0 for key " + entry2.getIntKey()), (bucket < 0 ? 1 : 0) != 0);
            MemoryOpenHashTableTest.writeValueToBucket(table1, -(bucket + 1), entry2.getIntValue());
        }
        table1.copyTo(table2, (oldBucket, newBucket, oldTable, newTable) -> {
            Assert.assertSame((Object)table1, (Object)oldTable);
            Assert.assertSame((Object)table2, (Object)newTable);
        });
        Map<ByteBuffer, ByteBuffer> expectedByteBufferMap = expectedMap.int2IntEntrySet().stream().collect(Collectors.toMap(entry -> MemoryOpenHashTableTest.expectedKey(entry.getIntKey()), entry -> MemoryOpenHashTableTest.expectedValue(entry.getIntValue())));
        MemoryOpenHashTableTest.assertEqualsMap(expectedByteBufferMap, table1);
        MemoryOpenHashTableTest.assertEqualsMap(expectedByteBufferMap, table2);
    }

    @Test
    public void testClear() {
        MemoryOpenHashTable table = MemoryOpenHashTableTest.createTable(64, 0.7, 4, 4);
        Int2IntOpenHashMap expectedMap = new Int2IntOpenHashMap();
        expectedMap.put(0, 1);
        expectedMap.put(-1, 2);
        for (Int2IntMap.Entry entry2 : expectedMap.int2IntEntrySet()) {
            int bucket = MemoryOpenHashTableTest.findAndInitBucket(table, entry2.getIntKey());
            Assert.assertTrue((String)("bucket < 0 for key " + entry2.getIntKey()), (bucket < 0 ? 1 : 0) != 0);
            MemoryOpenHashTableTest.writeValueToBucket(table, -(bucket + 1), entry2.getIntValue());
        }
        Map<ByteBuffer, ByteBuffer> expectedByteBufferMap = expectedMap.int2IntEntrySet().stream().collect(Collectors.toMap(entry -> MemoryOpenHashTableTest.expectedKey(entry.getIntKey()), entry -> MemoryOpenHashTableTest.expectedValue(entry.getIntValue())));
        MemoryOpenHashTableTest.assertEqualsMap(expectedByteBufferMap, table);
        table.clear();
        MemoryOpenHashTableTest.assertEqualsMap((Map<ByteBuffer, ByteBuffer>)ImmutableMap.of(), table);
    }

    private static int findAndInitBucket(MemoryOpenHashTable table, int key) {
        boolean keyMemoryPosition = true;
        WritableMemory keyMemory = WritableMemory.allocate((int)5);
        keyMemory.putInt(1L, key);
        int bucket = table.findBucket(HashTableUtils.hashMemory((Memory)keyMemory, (long)1L, (int)4), (Memory)keyMemory, 1);
        if (bucket < 0) {
            table.initBucket(-(bucket + 1), (Memory)keyMemory, 1);
        }
        return bucket;
    }

    private static void writeValueToBucket(MemoryOpenHashTable table, int bucket, int value) {
        int valuePosition = table.bucketMemoryPosition(bucket) + table.bucketValueOffset();
        table.memory().putInt((long)valuePosition, value);
    }

    private static Set<ByteBufferPair> pairSet(MemoryOpenHashTable table) {
        HashSet<ByteBufferPair> retVal = new HashSet<ByteBufferPair>();
        IntIterator bucketIterator = table.bucketIterator();
        while (bucketIterator.hasNext()) {
            int bucket = bucketIterator.nextInt();
            ByteBuffer entryBuffer = table.memory().getByteBuffer().duplicate();
            entryBuffer.position(table.bucketMemoryPosition(bucket));
            entryBuffer.limit(entryBuffer.position() + table.bucketSize());
            ByteBuffer keyBuffer = ByteBuffer.allocate(table.keySize());
            ByteBuffer keyDup = entryBuffer.duplicate();
            int keyPosition = keyDup.position() + table.bucketKeyOffset();
            keyDup.position(keyPosition);
            keyDup.limit(keyPosition + table.keySize());
            keyBuffer.put(keyDup);
            keyBuffer.position(0);
            ByteBuffer valueBuffer = ByteBuffer.allocate(table.valueSize());
            ByteBuffer valueDup = entryBuffer.duplicate();
            int valuePosition = valueDup.position() + table.bucketValueOffset();
            valueDup.position(valuePosition);
            valueDup.limit(valuePosition + table.valueSize());
            valueBuffer.put(valueDup);
            valueBuffer.position(0);
            retVal.add(new ByteBufferPair(keyBuffer, valueBuffer));
        }
        return retVal;
    }

    private static MemoryOpenHashTable createTable(int numBuckets, double loadFactor, int keySize, int valueSize) {
        int maxSize = (int)Math.floor((double)numBuckets * loadFactor);
        ByteBuffer buffer = ByteBuffer.allocate(MemoryOpenHashTable.memoryNeeded((int)numBuckets, (int)MemoryOpenHashTable.bucketSize((int)keySize, (int)valueSize)));
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (byte)ThreadLocalRandom.current().nextInt());
        }
        return new MemoryOpenHashTable(WritableMemory.writableWrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.nativeOrder()), numBuckets, maxSize, keySize, valueSize);
    }

    private static ByteBuffer expectedKey(int key) {
        return ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(0, key);
    }

    private static ByteBuffer expectedValue(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(0, value);
    }

    private static void assertEqualsMap(Map<ByteBuffer, ByteBuffer> expected, MemoryOpenHashTable actual) {
        Assert.assertEquals((String)"size", (long)expected.size(), (long)actual.size());
        Assert.assertEquals((String)"entries", expected.entrySet().stream().map(entry -> new ByteBufferPair((ByteBuffer)entry.getKey(), (ByteBuffer)entry.getValue())).collect(Collectors.toSet()), MemoryOpenHashTableTest.pairSet(actual));
    }

    private static class ByteBufferPair
    extends Pair<ByteBuffer, ByteBuffer> {
        public ByteBufferPair(ByteBuffer lhs, ByteBuffer rhs) {
            super((Object)lhs, (Object)rhs);
        }

        public String toString() {
            byte[] lhsBytes = new byte[((ByteBuffer)this.lhs).remaining()];
            ((ByteBuffer)this.lhs).duplicate().get(lhsBytes);
            byte[] rhsBytes = new byte[((ByteBuffer)this.rhs).remaining()];
            ((ByteBuffer)this.rhs).duplicate().get(rhsBytes);
            return "ByteBufferPair{lhs=" + Arrays.toString(lhsBytes) + ", rhs=" + Arrays.toString(rhsBytes) + "}";
        }
    }
}

