/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.InlineScanOperator;
import org.apache.druid.query.operator.NaiveSortOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorTestHelper;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Test;

public class NaiveSortOperatorTest {
    @Test
    public void testNoInputisHandledCorrectly() {
        NaiveSortOperator op = new NaiveSortOperator((Operator)InlineScanOperator.make(new RowsAndColumns[0]), (List)ImmutableList.of((Object)ColumnWithDirection.ascending((String)"someColumn")));
        new OperatorTestHelper().withPushFn(() -> someRac -> Operator.Signal.GO).runToCompletion((Operator)op);
    }

    @Test
    public void testSortAscending() {
        MapOfColumnsRowsAndColumns rac1 = this.racForColumn("c", new int[]{5, 3, 1});
        MapOfColumnsRowsAndColumns rac2 = this.racForColumn("c", new int[]{2, 6, 4});
        NaiveSortOperator op = new NaiveSortOperator((Operator)InlineScanOperator.make(new RowsAndColumns[]{rac1, rac2}), (List)ImmutableList.of((Object)ColumnWithDirection.ascending((String)"c")));
        new OperatorTestHelper().expectAndStopAfter(new RowsAndColumnsHelper().expectColumn("c", new int[]{1, 2, 3, 4, 5, 6})).runToCompletion((Operator)op);
    }

    @Test
    public void testSortDescending() {
        MapOfColumnsRowsAndColumns rac1 = this.racForColumn("c", new int[]{5, 3, 1});
        MapOfColumnsRowsAndColumns rac2 = this.racForColumn("c", new int[]{2, 6, 4});
        NaiveSortOperator op = new NaiveSortOperator((Operator)InlineScanOperator.make(new RowsAndColumns[]{rac1, rac2}), (List)ImmutableList.of((Object)ColumnWithDirection.descending((String)"c")));
        new OperatorTestHelper().expectAndStopAfter(new RowsAndColumnsHelper().expectColumn("c", new int[]{6, 5, 4, 3, 2, 1})).runToCompletion((Operator)op);
    }

    private MapOfColumnsRowsAndColumns racForColumn(String k1, Object arr) {
        if (Integer.TYPE.equals(arr.getClass().getComponentType())) {
            return this.racForColumn(k1, (Column)new IntArrayColumn((int[])arr));
        }
        throw new IllegalArgumentException("Not yet supported");
    }

    private MapOfColumnsRowsAndColumns racForColumn(String k1, Column v1) {
        return MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)k1, (Object)v1));
    }
}

