/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.operator.OffsetLimit;
import org.junit.Assert;
import org.junit.Test;

public class OffsetLimitTest {
    @Test
    public void testNone() {
        Assert.assertFalse((boolean)OffsetLimit.NONE.isPresent());
        Assert.assertFalse((boolean)OffsetLimit.NONE.hasOffset());
        Assert.assertFalse((boolean)OffsetLimit.NONE.hasLimit());
    }

    @Test
    public void testOffset() {
        int offset = 3;
        OffsetLimit ol = new OffsetLimit((long)offset, -1L);
        Assert.assertTrue((boolean)ol.hasOffset());
        Assert.assertFalse((boolean)ol.hasLimit());
        Assert.assertEquals((long)offset, (long)ol.getOffset());
        Assert.assertEquals((long)-1L, (long)ol.getLimit());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)ol.getLimitOrMax());
        Assert.assertEquals((long)offset, (long)ol.getFromIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)ol.getToIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)ol.getFromIndex(1L));
        Assert.assertEquals((long)0L, (long)ol.getFromIndex((long)offset));
        Assert.assertEquals((long)0L, (long)ol.getToIndex((long)offset));
    }

    @Test
    public void testLimit() {
        OffsetLimit ol = new OffsetLimit(0L, 4L);
        Assert.assertFalse((boolean)ol.hasOffset());
        Assert.assertTrue((boolean)ol.hasLimit());
        Assert.assertEquals((long)0L, (long)ol.getOffset());
        Assert.assertEquals((long)4L, (long)ol.getLimit());
        Assert.assertEquals((long)4L, (long)ol.getLimitOrMax());
        Assert.assertEquals((long)0L, (long)ol.getFromIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)4L, (long)ol.getToIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)ol.getFromIndex(2L));
        Assert.assertEquals((long)2L, (long)ol.getToIndex(2L));
    }

    @Test
    public void testOffsetLimit() {
        int offset = 3;
        int limit = 10;
        OffsetLimit ol = new OffsetLimit((long)offset, (long)limit);
        Assert.assertTrue((boolean)ol.hasOffset());
        Assert.assertTrue((boolean)ol.hasLimit());
        Assert.assertEquals((long)offset, (long)ol.getOffset());
        Assert.assertEquals((long)limit, (long)ol.getLimit());
        Assert.assertEquals((long)limit, (long)ol.getLimitOrMax());
        Assert.assertEquals((long)offset, (long)ol.getFromIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)(offset + limit), (long)ol.getToIndex(Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)ol.getFromIndex((long)offset));
        Assert.assertEquals((long)0L, (long)ol.getToIndex((long)offset));
        Assert.assertEquals((long)offset, (long)ol.getFromIndex((long)(offset + 1)));
        Assert.assertEquals((long)(offset + 1), (long)ol.getToIndex((long)(offset + 1)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidOffset() {
        new OffsetLimit(-1L, -1L);
    }

    @Test
    public void testNegativeLimitsAreNotDifferent() {
        OffsetLimit ol1 = new OffsetLimit(1L, -1L);
        OffsetLimit ol2 = new OffsetLimit(1L, -2L);
        Assert.assertEquals((Object)ol1, (Object)ol2);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(OffsetLimit.class).verify();
    }
}

