/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.ranking.WindowPercentileProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class WindowPercentileProcessorTest {
    @Test
    public void testPercentileProcessing() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{88, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.4728, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowPercentileProcessor("1", 1), new WindowPercentileProcessor("2", 2), new WindowPercentileProcessor("3", 3), new WindowPercentileProcessor("4", 4), new WindowPercentileProcessor("5", 5), new WindowPercentileProcessor("6", 6), new WindowPercentileProcessor("7", 7), new WindowPercentileProcessor("8", 8), new WindowPercentileProcessor("9", 9), new WindowPercentileProcessor("10", 10), new WindowPercentileProcessor("10292", 10292)});
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9", (Object)"10", (Object)"10292"), (Object)processor.getOutputColumnNames());
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("intCol", new int[]{88, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.4728, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("1", new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}).expectColumn("2", new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2}).expectColumn("3", new int[]{1, 1, 1, 1, 2, 2, 2, 3, 3, 3}).expectColumn("4", new int[]{1, 1, 1, 2, 2, 2, 3, 3, 4, 4}).expectColumn("5", new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5}).expectColumn("6", new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 6}).expectColumn("7", new int[]{1, 1, 2, 2, 3, 3, 4, 5, 6, 7}).expectColumn("8", new int[]{1, 1, 2, 2, 3, 4, 5, 6, 7, 8}).expectColumn("9", new int[]{1, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("10", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).expectColumn("10292", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

