/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.value.WindowOffsetProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class WindowLagProcessorTest {
    @Test
    public void testLagProcessing() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowOffsetProcessor("intCol", "laggardIntCol", -2), new WindowOffsetProcessor("doubleCol", "laggardDoubleCol", -4), new WindowOffsetProcessor("objectCol", "laggardObjectCol", -1)});
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        expectations.columnHelper("laggardIntCol", 10, ColumnType.LONG).setExpectation(new int[]{0, 0, 0, 1, 2, 3, 4, 5, 6, 7}).setNulls(new int[]{0, 1});
        expectations.columnHelper("laggardDoubleCol", 10, ColumnType.DOUBLE).setExpectation(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0}).setNulls(new int[]{0, 1, 2, 3});
        expectations.columnHelper("laggardObjectCol", 10, ColumnType.STRING).setExpectation(new String[]{null, "a", "b", "c", "d", "e", "f", "g", "h", "i"}).setNulls(new int[]{0});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

