/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.Collections;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Assert;
import org.junit.Test;

public class MapOfColumnsRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    public MapOfColumnsRowsAndColumnsTest() {
        super(MapOfColumnsRowsAndColumns.class);
    }

    @Test
    public void testMakeWithEmptyAndNull() {
        boolean exceptionThrown = false;
        try {
            MapOfColumnsRowsAndColumns.fromMap(null);
        }
        catch (ISE ex) {
            Assert.assertEquals((Object)"map[null] cannot be null or empty.", (Object)ex.getMessage());
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            MapOfColumnsRowsAndColumns.fromMap(Collections.emptyMap());
        }
        catch (ISE ex) {
            Assert.assertEquals((Object)"map[{}] cannot be null or empty.", (Object)ex.getMessage());
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testExceptionOnMismatchedCells() {
        boolean exceptionThrown = false;
        try {
            MapOfColumnsRowsAndColumns.of((String)"1", (Column)new IntArrayColumn(new int[]{0}), (String)"2", (Column)new IntArrayColumn(new int[]{0, 1}));
        }
        catch (ISE ex) {
            Assert.assertEquals((Object)"Mismatched numCells, expectedNumCells[1], actual[2] from col[2].", (Object)ex.getMessage());
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }
}

