/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueFramesIterable;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ScanResultValueFramesIterableTest
extends InitializedNullHandlingTest {
    private static final RowSignature SIGNATURE1 = RowSignature.builder().add("col1", ColumnType.LONG).add("col2", ColumnType.DOUBLE).build();
    private static final RowSignature SIGNATURE2 = RowSignature.builder().add("col1", ColumnType.DOUBLE).add("col2", ColumnType.LONG).build();
    private static final RowSignature SIGNATURE3 = RowSignature.builder().add("col1", ColumnType.DOUBLE).add("col2", ColumnType.LONG).add("col3", null).build();
    private static final RowSignature SIGNATURE4 = RowSignature.builder().add("col1", ColumnType.DOUBLE).add("col3", null).add("col2", ColumnType.LONG).build();

    @Test
    public void testEmptySequence() {
        ScanResultValueFramesIterable iterable = ScanResultValueFramesIterableTest.createIterable(new ScanResultValue[0]);
        ArrayList frames = Lists.newArrayList((Iterable)iterable);
        Assert.assertEquals((long)0L, (long)frames.size());
    }

    @Test
    public void testAllEmptyScanResultValuesInSequence() {
        ArrayList frames1 = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0)));
        Assert.assertEquals((long)0L, (long)frames1.size());
        ArrayList frames2 = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(0)));
        Assert.assertEquals((long)0L, (long)frames2.size());
    }

    @Test
    public void testBatchingWithHomogenousScanResultValues() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(2)));
        Assert.assertEquals((long)1L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}, (Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource((List)frames, SIGNATURE1).getRowsAsSequence());
    }

    @Test
    public void testBatchingWithHomogenousAndEmptyScanResultValues() {
        List[] framesList = new List[]{Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(0))), Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue2(0))), Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(0)))};
        for (List frames : framesList) {
            Assert.assertEquals((long)1L, (long)frames.size());
            QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}, (Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames, SIGNATURE1).getRowsAsSequence());
        }
    }

    @Test
    public void testBatchingWithHeterogenousScanResultValues() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue2(2)));
        Assert.assertEquals((long)2L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(0, 1), SIGNATURE1).getRowsAsSequence());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{2000.0, 2100L}, (Object)new Object[]{2001.0, 2101L}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(1, 2), SIGNATURE2).getRowsAsSequence());
    }

    @Test
    public void testBatchingWithHeterogenousScanResultValuesAndNullTypes() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue3(2)));
        Assert.assertEquals((long)2L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(0, 1), SIGNATURE1).getRowsAsSequence());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{3000.0, 3100L}, (Object)new Object[]{3001.0, 3101L}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(1, 2), SIGNATURE2).getRowsAsSequence());
    }

    @Test
    public void testBatchingWithHeterogenousAndEmptyScanResultValues() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(2), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0)));
        Assert.assertEquals((long)2L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(0, 1), SIGNATURE1).getRowsAsSequence());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{2000.0, 2100L}, (Object)new Object[]{2001.0, 2101L}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(1, 2), SIGNATURE2).getRowsAsSequence());
    }

    @Test
    public void testBatchingWithHeterogenousAndEmptyScanResultValuesAndNullTypes() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue1(2), ScanResultValueFramesIterableTest.scanResultValue1(0), ScanResultValueFramesIterableTest.scanResultValue2(2), ScanResultValueFramesIterableTest.scanResultValue2(0), ScanResultValueFramesIterableTest.scanResultValue2(0)));
        Assert.assertEquals((long)2L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{1000L, 1100.0}, (Object)new Object[]{1001L, 1101.0}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(0, 1), SIGNATURE1).getRowsAsSequence());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{2000.0, 2100L}, (Object)new Object[]{2001.0, 2101L}), (Sequence<Object[]>)new FrameBasedInlineDataSource(frames.subList(1, 2), SIGNATURE2).getRowsAsSequence());
    }

    @Test
    public void testBatchingWithDifferentRowSignaturesButSameTrimmedRowSignature() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.scanResultValue3(0), ScanResultValueFramesIterableTest.scanResultValue4(0), ScanResultValueFramesIterableTest.scanResultValue3(2), ScanResultValueFramesIterableTest.scanResultValue3(0), ScanResultValueFramesIterableTest.scanResultValue4(2), ScanResultValueFramesIterableTest.scanResultValue4(0), ScanResultValueFramesIterableTest.scanResultValue3(0)));
        Assert.assertEquals((long)1L, (long)frames.size());
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[]{3000.0, 3100L}, (Object)new Object[]{3001.0, 3101L}, (Object)new Object[]{4000.0, 4100L}, (Object)new Object[]{4001.0, 4101L}), (Sequence<Object[]>)new FrameBasedInlineDataSource((List)frames, SIGNATURE2).getRowsAsSequence());
    }

    @Test
    public void testExceptionThrownWithMissingType() {
        Sequence frames = Sequences.simple((Iterable)ScanResultValueFramesIterableTest.createIterable(ScanResultValueFramesIterableTest.incompleteTypeScanResultValue(1)));
        Assert.assertThrows(DruidException.class, () -> ((Sequence)frames).toList());
    }

    @Test
    public void testSplitting() {
        ArrayList frames = Lists.newArrayList((Iterable)ScanResultValueFramesIterableTest.createIterable(Collections.nCopies(100, ScanResultValueFramesIterableTest.scanResultValue1(2)).toArray(new ScanResultValue[0])));
        Assert.assertEquals((long)5L, (long)frames.size());
    }

    private static ScanResultValueFramesIterable createIterable(ScanResultValue ... scanResultValues) {
        return new ScanResultValueFramesIterable(Sequences.simple(Arrays.asList(scanResultValues)), (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(1000), false, null, rowSignature -> rows -> rows);
    }

    /*
     * Exception decompiling
     */
    private static ScanResultValue scanResultValue1(int numRows) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ScanResultValue scanResultValue2(int numRows) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ScanResultValue scanResultValue3(int numRows) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ScanResultValue scanResultValue4(int numRows) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static ScanResultValue incompleteTypeScanResultValue(int numRows) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

