/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.junit.Assert;
import org.junit.Test;

public class TimeBoundaryQueryTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testContextSerde() throws Exception {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)1, (Object)"useCache", (Object)true, (Object)"populateCache", (Object)true, (Object)"finalize", (Object)true)).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        TimeBoundaryQuery serdeQuery = (TimeBoundaryQuery)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), TimeBoundaryQuery.class)), TimeBoundaryQuery.class);
        QueryContext queryContext = query.context();
        Assert.assertEquals((long)1L, (long)queryContext.getInt("priority").intValue());
        Assert.assertEquals((Object)true, (Object)queryContext.getBoolean("useCache"));
        Assert.assertEquals((Object)true, (Object)queryContext.getBoolean("populateCache"));
        Assert.assertEquals((Object)true, (Object)queryContext.getBoolean("finalize"));
    }

    @Test
    public void testContextSerde2() throws Exception {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals("2013/2014").context((Map)ImmutableMap.of((Object)"priority", (Object)"1", (Object)"useCache", (Object)"true", (Object)"populateCache", (Object)"true", (Object)"finalize", (Object)"true")).build();
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        TimeBoundaryQuery serdeQuery = (TimeBoundaryQuery)mapper.readValue(mapper.writeValueAsBytes(mapper.readValue(mapper.writeValueAsString((Object)query), TimeBoundaryQuery.class)), TimeBoundaryQuery.class);
        QueryContext queryContext = query.context();
        Assert.assertEquals((Object)"1", (Object)queryContext.get("priority"));
        Assert.assertEquals((Object)"true", (Object)queryContext.get("useCache"));
        Assert.assertEquals((Object)"true", (Object)queryContext.get("populateCache"));
        Assert.assertEquals((Object)"true", (Object)queryContext.get("finalize"));
    }
}

