/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NestedDataTimeseriesQueryTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final Closer closer;
    private final AggregationTestHelper helper = AggregationTestHelper.createTimeseriesQueryAggregationTestHelper(BuiltInTypesModule.getJacksonModulesList(), this.tempFolder);
    private final BiFunction<TemporaryFolder, Closer, List<Segment>> segmentsGenerator;
    private final QueryContexts.Vectorize vectorize;
    private final String segmentsName;

    @Parameterized.Parameters(name="{0}:vectorize={1}")
    public static Iterable<Object[]> constructorFeeder() {
        List<BiFunction<TemporaryFolder, Closer, List<Segment>>> segmentsGenerators = NestedDataTestUtils.getSegmentGenerators("nested-all-types-test-data.json");
        return QueryRunnerTestHelper.cartesian(new Iterable[]{segmentsGenerators, ImmutableList.of((Object)"false", (Object)"force")});
    }

    private static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        TestHelper.assertExpectedResults(expectedResults, results);
    }

    public NestedDataTimeseriesQueryTest(BiFunction<TemporaryFolder, Closer, List<Segment>> segmentsGenerator, String vectorize) {
        this.segmentsGenerator = segmentsGenerator;
        this.segmentsName = segmentsGenerator.toString();
        this.vectorize = QueryContexts.Vectorize.fromString((String)vectorize);
        this.closer = Closer.create();
    }

    public Map<String, Object> getContext() {
        return ImmutableMap.of((Object)"vectorize", (Object)this.vectorize.toString(), (Object)"vectorizeVirtualColumns", (Object)this.vectorize.toString());
    }

    @Test
    public void testCount() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)14L)))));
    }

    @Test
    public void testSums() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sumLong", "long"), new DoubleSumAggregatorFactory("sumDouble", "double"), new LongSumAggregatorFactory("sumNestedLong", "v0"), new DoubleSumAggregatorFactory("sumNestedDouble", "v1"), new DoubleSumAggregatorFactory("sumNestedLongFromArray", "v2"), new DoubleSumAggregatorFactory("sumVariantNumeric", "variantNumeric"), new DoubleSumAggregatorFactory("sumNestedVariantNumeric", "v3")}).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("obj", "$.a", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("obj", "$.b.y", "v1", ColumnType.DOUBLE), new NestedFieldVirtualColumn("obj", "$.b.z[0]", "v2", ColumnType.LONG), new NestedFieldVirtualColumn("complexObj", "$.x", "v3", ColumnType.DOUBLE)}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"count", (Object)14L).put((Object)"sumLong", (Object)30L).put((Object)"sumDouble", (Object)33.2).put((Object)"sumNestedLong", (Object)5600L).put((Object)"sumNestedDouble", (Object)11.0).put((Object)"sumNestedLongFromArray", (Object)44.0).put((Object)"sumVariantNumeric", (Object)-1987.3999999999999).put((Object)"sumNestedVariantNumeric", (Object)5786.8).build()))));
    }

    @Test
    public void testSumsNoVectorize() {
        if (QueryContexts.Vectorize.FORCE.equals((Object)this.vectorize)) {
            return;
        }
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sumVariantLong", "variant"), new DoubleSumAggregatorFactory("sumVariantDouble", "variant"), new LongSumAggregatorFactory("sumVariantArraysLong", "variantWithArrays"), new DoubleSumAggregatorFactory("sumVariantArraysDouble", "variantWithArrays")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"count", (Object)14L).put((Object)"sumVariantLong", (Object)112L).put((Object)"sumVariantDouble", (Object)112.0).put((Object)"sumVariantArraysLong", (Object)10L).put((Object)"sumVariantArraysDouble", (Object)10.0).build()))));
    }

    @Test
    public void testFilterLong() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new OrDimFilter(new DimFilter[]{new AndDimFilter(new DimFilter[]{new EqualityFilter("long", ColumnType.LONG, (Object)2L, null), new EqualityFilter("v0", ColumnType.LONG, (Object)2L, null)}), NullFilter.forColumn((String)"long"), NullFilter.forColumn((String)"v1")})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("long", "$.", "v0", ColumnType.LONG), new NestedFieldVirtualColumn("obj", "$.b.z[1]", "v1", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)8L)))));
    }

    @Test
    public void testFilterLongArrayElementFilters() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{NullFilter.forColumn((String)"v0"), NullFilter.forColumn((String)"v1"), NullFilter.forColumn((String)"v2")})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("arrayLongNulls", "$[1]", "v0", ColumnType.STRING), new NestedFieldVirtualColumn("arrayLongNulls", "$[1]", "v1", ColumnType.LONG), new NestedFieldVirtualColumn("arrayStringNulls", "$[1]", "v2", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)8L)))));
    }

    @Test
    public void testFilterVariantAsString() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("variant", ColumnType.STRING, (Object)"hello", null), new EqualityFilter("v0", ColumnType.STRING, (Object)"hello", null)})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variant", "$.", "v0", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantAsStringNoIndexes() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("variant", ColumnType.STRING, (Object)"hello", new FilterTuning(Boolean.valueOf(false), null, null)), new EqualityFilter("v0", ColumnType.STRING, (Object)"hello", new FilterTuning(Boolean.valueOf(false), null, null))})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variant", "$.", "v0", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantAsLong() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("variant", ColumnType.LONG, (Object)51L, null), new EqualityFilter("v0", ColumnType.LONG, (Object)51L, null)})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variant", "$.", "v0", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantAsLongNoIndexes() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("variant", ColumnType.LONG, (Object)51L, new FilterTuning(Boolean.valueOf(false), null, null)), new EqualityFilter("v0", ColumnType.LONG, (Object)51L, new FilterTuning(Boolean.valueOf(false), null, null))})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variant", "$.", "v0", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantArrayAsString() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("v0", ColumnType.STRING, (Object)"1", null)})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variantWithArrays", "$.", "v0", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)4L)))));
    }

    @Test
    public void testFilterVariantArrayAsDouble() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("v0", ColumnType.DOUBLE, (Object)3.0, null)})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variantWithArrays", "$.", "v0", ColumnType.STRING)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantArrayAsArray() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new AndDimFilter(new DimFilter[]{new EqualityFilter("variantWithArrays", ColumnType.LONG_ARRAY, Arrays.asList(51, -35), null), new EqualityFilter("v0", ColumnType.LONG_ARRAY, Arrays.asList(51, -35), null)})).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("variantWithArrays", "$.", "v0", ColumnType.STRING_ARRAY)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantArrayStringArray() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new EqualityFilter("variantWithArrays", ColumnType.STRING_ARRAY, Collections.singletonList("hello"), null)).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("long", "$.", "v0", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    @Test
    public void testFilterVariantArrayStringArrayNoIndexes() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test_datasource").intervals(Collections.singletonList(Intervals.ETERNITY)).filters((DimFilter)new EqualityFilter("variantWithArrays", ColumnType.STRING_ARRAY, Collections.singletonList("hello"), new FilterTuning(Boolean.valueOf(false), null, null))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("long", "$.", "v0", ColumnType.LONG)}).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")}).context(this.getContext()).build();
        this.runResults(query, (List<Result<TimeseriesResultValue>>)ImmutableList.of((Object)new Result(DateTimes.of((String)"2023-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L)))));
    }

    private void runResults(TimeseriesQuery timeseriesQuery, List<Result<TimeseriesResultValue>> expectedResults) {
        List<Segment> segments = this.segmentsGenerator.apply(this.tempFolder, this.closer);
        Supplier<List> runner = () -> this.helper.runQueryOnSegmentsObjs(segments, timeseriesQuery).toList();
        CursorBuildSpec spec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)timeseriesQuery, null);
        boolean allCanVectorize = segments.stream().allMatch(s -> {
            CursorHolder cursorHolder = s.asCursorFactory().makeCursorHolder(spec);
            boolean canVectorize = cursorHolder.canVectorize();
            cursorHolder.close();
            return canVectorize;
        });
        if (!allCanVectorize && this.vectorize == QueryContexts.Vectorize.FORCE) {
            Throwable t = Assert.assertThrows(RuntimeException.class, runner::get);
            Assert.assertEquals((Object)"org.apache.druid.java.util.common.ISE: Cannot vectorize!", (Object)t.getMessage());
            return;
        }
        List results = runner.get();
        NestedDataTimeseriesQueryTest.assertExpectedResults(expectedResults, results);
    }
}

