/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNCursorInspector;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class TopNMetricSpecOptimizationsTest
extends InitializedNullHandlingTest {
    private static final List<AggregatorFactory> AGGS = Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})));

    @Test
    public void testShouldOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators(AGGS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, this.makeCursorInspector("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality), cardinality);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(threshold), (Object)thePair.rhs);
    }

    @Test
    public void testAlsoShouldOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-30T01:00:00Z").aggregators(AGGS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, this.makeCursorInspector("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality), cardinality);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(threshold), (Object)thePair.rhs);
    }

    @Test
    public void testShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-30T01:00:00Z").aggregators(AGGS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, this.makeCursorInspector("2018-05-30T00:00:00Z", "2018-05-31T00:00:00Z", cardinality), cardinality);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    @Test
    public void testAlsoShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").filters("quality", "entertainment").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators(AGGS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, this.makeCursorInspector("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality), cardinality);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    @Test
    public void testAgainShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators(AGGS).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, this.makeCursorInspector("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality), cardinality);
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    private TopNCursorInspector makeCursorInspector(String start, String end, int cardinality) {
        return new TopNCursorInspector(new ColumnInspector(){

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return null;
            }
        }, (TopNOptimizationInspector)new SimpleTopNOptimizationInspector(true), Intervals.of((String)(start + "/" + end)), cardinality);
    }

    private DimensionSelector makeFakeDimSelector(final int cardinality) {
        DimensionSelector dimSelector = new DimensionSelector(){

            public int getValueCardinality() {
                return cardinality;
            }

            public IndexedInts getRow() {
                return null;
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return null;
            }

            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                return null;
            }

            @Nullable
            public String lookupName(int id) {
                return null;
            }

            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Nullable
            public Object getObject() {
                return null;
            }

            public Class classOfObject() {
                return null;
            }
        };
        return dimSelector;
    }
}

