/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DoubleDimensionHandler;
import org.apache.druid.segment.FloatDimensionHandler;
import org.apache.druid.segment.LongDimensionHandler;
import org.apache.druid.segment.StringDimensionHandler;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DimensionHandlerUtilsTest
extends InitializedNullHandlingTest {
    private static final String DIM_NAME = "dim";
    private static final String TYPE = "testType";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final Object[] LONG_OBJECT_ARRAY = new Object[]{1L, 2L};
    private static final Object[] DOUBLE_OBJECT_ARRAY = new Object[]{1.0, 2.0};
    private static final Object[] FLOAT_OBJECT_ARRAY = new Object[]{Float.valueOf(1.0f), Float.valueOf(2.0f)};
    private static final Object[] STRING_OBJECT_ARRAY = new Object[]{"1", "2"};
    private static final Object[] DECIMAL_STRING_OBJECT_ARRAY = new Object[]{"1.0", "2.0"};

    @BeforeClass
    public static void setupTests() {
        DimensionHandlerUtils.registerDimensionHandlerProvider((String)TYPE, d -> new DoubleDimensionHandler(d){

            public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
                return new TestDimensionSchema(d, null, capabilities.hasBitmapIndexes());
            }
        });
    }

    @Test
    public void testGetHandlerFromComplexCapabilities() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)TYPE));
        DimensionHandler dimensionHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertEquals((Object)DIM_NAME, (Object)dimensionHandler.getDimensionName());
        Assert.assertTrue((boolean)(dimensionHandler instanceof DoubleDimensionHandler));
        Assert.assertTrue((boolean)(dimensionHandler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof TestDimensionSchema));
    }

    @Test
    public void testGetHandlerFromUnknownComplexCapabilities() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Can't find DimensionHandlerProvider for typeName [unknown]");
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)"unknown"));
        DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
    }

    @Test
    public void testGetHandlerFromStringCapabilities() {
        ColumnCapabilitiesImpl stringCapabilities = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesUnique(true);
        DimensionHandler stringHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)stringCapabilities, (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
        Assert.assertTrue((boolean)(stringHandler instanceof StringDimensionHandler));
        Assert.assertTrue((boolean)(stringHandler.getDimensionSchema((ColumnCapabilities)stringCapabilities) instanceof StringDimensionSchema));
    }

    @Test
    public void testGetHandlerFromStringCapabilitiesSpatialIndexes() {
        ColumnCapabilitiesImpl stringCapabilities = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesUnique(true).setHasSpatialIndexes(true);
        DimensionHandler spatialHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)stringCapabilities, (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
        Assert.assertTrue((boolean)(spatialHandler instanceof StringDimensionHandler));
        Assert.assertTrue((boolean)(spatialHandler.getDimensionSchema((ColumnCapabilities)stringCapabilities) instanceof NewSpatialDimensionSchema));
    }

    @Test
    public void testGetHandlerFromFloatCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof FloatDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof FloatDimensionSchema));
    }

    @Test
    public void testGetHandlerFromDoubleCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof DoubleDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof DoubleDimensionSchema));
    }

    @Test
    public void testGetHandlerFromLongCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof LongDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof LongDimensionSchema));
    }

    @Test
    public void testComparableLongList() {
        Assert.assertArrayEquals(null, (Object[])DimensionHandlerUtils.convertToArray(null, (TypeSignature)ColumnType.LONG));
        Assert.assertArrayEquals((Object[])LONG_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)ImmutableList.of((Object)1L, (Object)2L), (TypeSignature)ColumnType.LONG));
        Assert.assertArrayEquals((Object[])LONG_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)FLOAT_OBJECT_ARRAY, (TypeSignature)ColumnType.LONG));
        DimensionHandlerUtilsTest.assertArrayCases(LONG_OBJECT_ARRAY, ColumnType.LONG);
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1L, (TypeSignature)ColumnType.LONG));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1L, (TypeSignature)ColumnType.LONG_ARRAY));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1L, (TypeSignature)ColumnType.STRING));
    }

    @Test
    public void testComparableFloatList() {
        Assert.assertArrayEquals(null, (Object[])DimensionHandlerUtils.convertToArray(null, (TypeSignature)ColumnType.FLOAT));
        Assert.assertArrayEquals((Object[])FLOAT_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)), (TypeSignature)ColumnType.FLOAT));
        Assert.assertArrayEquals((Object[])FLOAT_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)LONG_OBJECT_ARRAY, (TypeSignature)ColumnType.FLOAT));
        DimensionHandlerUtilsTest.assertArrayCases(FLOAT_OBJECT_ARRAY, ColumnType.FLOAT);
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)Float.valueOf(1.0f), (TypeSignature)ColumnType.FLOAT));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)Float.valueOf(1.0f), (TypeSignature)ColumnType.FLOAT_ARRAY));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)Float.valueOf(1.0f), (TypeSignature)ColumnType.STRING));
    }

    @Test
    public void testComparableDoubleList() {
        Assert.assertArrayEquals(null, (Object[])DimensionHandlerUtils.convertToArray(null, (TypeSignature)ColumnType.DOUBLE));
        Assert.assertArrayEquals((Object[])DOUBLE_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)ImmutableList.of((Object)1.0, (Object)2.0), (TypeSignature)ColumnType.DOUBLE));
        Assert.assertArrayEquals((Object[])DOUBLE_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.convertToArray((Object)FLOAT_OBJECT_ARRAY, (TypeSignature)ColumnType.DOUBLE));
        DimensionHandlerUtilsTest.assertArrayCases(DOUBLE_OBJECT_ARRAY, ColumnType.DOUBLE);
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1.0, (TypeSignature)ColumnType.DOUBLE));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1.0, (TypeSignature)ColumnType.DOUBLE_ARRAY));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.convertToArray((Object)1.0, (TypeSignature)ColumnType.STRING));
    }

    @Test
    public void testComparableStringArrayList() {
        Assert.assertArrayEquals(null, (Object[])DimensionHandlerUtils.coerceToStringArray(null));
        Assert.assertArrayEquals((Object[])STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)ImmutableList.of((Object)"1", (Object)"2")));
        Assert.assertArrayEquals((Object[])STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)new Object[]{1L, 2L}));
        Assert.assertArrayEquals((Object[])STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)new Long[]{1L, 2L}));
        Assert.assertArrayEquals((Object[])DECIMAL_STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)new String[]{"1.0", "2.0"}));
        Assert.assertArrayEquals((Object[])DECIMAL_STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)new Double[]{1.0, 2.0}));
        Assert.assertArrayEquals((Object[])DECIMAL_STRING_OBJECT_ARRAY, (Object[])DimensionHandlerUtils.coerceToStringArray((Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}));
        Assert.assertThrows(ISE.class, () -> DimensionHandlerUtils.coerceToStringArray((Object)"1"));
    }

    private static void assertArrayCases(Object[] expectedObject, ColumnType elementType) {
        Assert.assertArrayEquals((Object[])expectedObject, (Object[])DimensionHandlerUtils.convertToArray((Object)new Object[]{1L, 2L}, (TypeSignature)elementType));
        Assert.assertArrayEquals((Object[])expectedObject, (Object[])DimensionHandlerUtils.convertToArray((Object)new Long[]{1L, 2L}, (TypeSignature)elementType));
        Assert.assertArrayEquals((Object[])expectedObject, (Object[])DimensionHandlerUtils.convertToArray((Object)new String[]{"1.0", "2.0"}, (TypeSignature)elementType));
        Assert.assertArrayEquals((Object[])expectedObject, (Object[])DimensionHandlerUtils.convertToArray((Object)new Double[]{1.0, 2.0}, (TypeSignature)elementType));
        Assert.assertArrayEquals((Object[])expectedObject, (Object[])DimensionHandlerUtils.convertToArray((Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}, (TypeSignature)elementType));
    }

    private static class TestDimensionSchema
    extends DimensionSchema {
        protected TestDimensionSchema(String name, DimensionSchema.MultiValueHandling multiValueHandling, boolean createBitmapIndex) {
            super(name, multiValueHandling, createBitmapIndex);
        }

        public String getTypeName() {
            return DimensionHandlerUtilsTest.TYPE;
        }

        public ColumnType getColumnType() {
            return ColumnType.ofComplex((String)DimensionHandlerUtilsTest.TYPE);
        }
    }
}

