/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EmptyIndexTest {
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public EmptyIndexTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyIndex() throws Exception {
        File tmpDir = File.createTempFile("emptyIndex", "");
        if (!tmpDir.delete()) {
            throw new IllegalStateException("tmp delete failed");
        }
        if (!tmpDir.mkdir()) {
            throw new IllegalStateException("tmp mkdir failed");
        }
        try {
            IncrementalIndex emptyIndex = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[0]).setMaxRowCount(1000).build();
            IncrementalIndexAdapter emptyIndexAdapter = new IncrementalIndexAdapter(Intervals.of((String)"2012-08-01/P3D"), (IncrementalIndexRowSelector)emptyIndex, (BitmapFactory)new ConciseBitmapFactory());
            TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory).merge(Collections.singletonList(emptyIndexAdapter), true, new AggregatorFactory[0], tmpDir, DimensionsSpec.EMPTY, IndexSpec.DEFAULT, -1);
            QueryableIndex emptyQueryableIndex = TestHelper.getTestIndexIO().loadIndex(tmpDir);
            Assert.assertEquals((String)"getDimensionNames", (long)0L, (long)Iterables.size((Iterable)emptyQueryableIndex.getAvailableDimensions()));
            Assert.assertEquals((String)"getMetricNames", (long)0L, (long)emptyQueryableIndex.getColumnNames().size());
            Assert.assertEquals((String)"getDataInterval", (Object)Intervals.of((String)"2012-08-01/P3D"), (Object)emptyQueryableIndex.getDataInterval());
            Assert.assertEquals((String)"getReadOnlyTimestamps", (long)0L, (long)emptyQueryableIndex.getColumnHolder("__time").getLength());
        }
        finally {
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }
}

