/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.NestedDataColumnIndexerV4;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NestedDataColumnIndexerV4Test
extends InitializedNullHandlingTest {
    private static final String TIME_COL = "time";
    private static final String STRING_COL = "string";
    private static final String STRING_ARRAY_COL = "string_array";
    private static final String LONG_COL = "long";
    private static final String DOUBLE_COL = "double";
    private static final String VARIANT_COL = "variant";
    private static final String NESTED_COL = "nested";

    @BeforeClass
    public static void setup() {
        BuiltInTypesModule.registerHandlersAndSerde();
    }

    @Test
    public void testKeySizeEstimation() {
        NestedDataColumnIndexerV4 indexer = new NestedDataColumnIndexerV4();
        Assert.assertEquals((long)-1L, (long)indexer.getCardinality());
        int baseCardinality = 0;
        Assert.assertEquals((long)baseCardinality, (long)indexer.globalDictionary.getCardinality());
        EncodedKeyComponent key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)"foo"), false);
        Assert.assertEquals((long)228L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 1), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)"foo"), false);
        Assert.assertEquals((long)112L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 1), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)10L, false);
        Assert.assertEquals((long)94L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 2), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)10L, false);
        Assert.assertEquals((long)16L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 2), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)11L, false);
        Assert.assertEquals((long)48L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 3), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), false);
        Assert.assertEquals((long)276L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), false);
        Assert.assertEquals((long)56L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L)), false);
        Assert.assertEquals((long)286L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L)), false);
        Assert.assertEquals((long)118L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)"", false);
        Assert.assertEquals((long)104L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 6), (long)indexer.globalDictionary.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)0, false);
        Assert.assertEquals((long)48L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 7), (long)indexer.globalDictionary.getCardinality());
        Assert.assertEquals((long)-1L, (long)indexer.getCardinality());
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootString() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, STRING_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, STRING_COL, "b"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, STRING_COL, "c"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, STRING_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, STRING_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(STRING_COL, STRING_COL, ColumnType.STRING);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
            DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
            Assert.assertEquals((Object)"a", (Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"a", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"a", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)"b", (Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"b", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"b", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)"c", (Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"c", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"c", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootLong() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, LONG_COL, 1L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, LONG_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, LONG_COL, 3L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, LONG_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, LONG_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(LONG_COL, LONG_COL, ColumnType.LONG);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
            DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
            Assert.assertEquals((Object)1L, (Object)valueSelector.getObject());
            Assert.assertEquals((long)1L, (long)valueSelector.getLong());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"1", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)2L, (Object)valueSelector.getObject());
            Assert.assertEquals((long)2L, (long)valueSelector.getLong());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"2", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"2", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)3L, (Object)valueSelector.getObject());
            Assert.assertEquals((long)3L, (long)valueSelector.getLong());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"3", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"3", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootDouble() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, DOUBLE_COL, 1.1));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, DOUBLE_COL, 2.2));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, DOUBLE_COL, 3.3));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, DOUBLE_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, DOUBLE_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(DOUBLE_COL, DOUBLE_COL, ColumnType.DOUBLE);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
            DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
            Assert.assertEquals((Object)1.1, (Object)valueSelector.getObject());
            Assert.assertEquals((double)1.1, (double)valueSelector.getDouble(), (double)0.0);
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"1.1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"1.1", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)2.2, (Object)valueSelector.getObject());
            Assert.assertEquals((double)2.2, (double)valueSelector.getDouble(), (double)0.0);
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"2.2", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"2.2", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)3.3, (Object)valueSelector.getObject());
            Assert.assertEquals((double)3.3, (double)valueSelector.getDouble(), (double)0.0);
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)"3.3", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)"3.3", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootStringArray() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, STRING_ARRAY_COL, new String[]{"a"}));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, STRING_ARRAY_COL, new Object[]{"b", "c"}));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, STRING_ARRAY_COL, ImmutableList.of((Object)"d", (Object)"e")));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, STRING_ARRAY_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, STRING_ARRAY_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(STRING_ARRAY_COL, STRING_ARRAY_COL, ColumnType.STRING);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
            Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerV4Test.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$0(cursor, (DimensionSpec)dimensionSpec));
            Assert.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])((Object[])valueSelector.getObject()));
            cursor.advance();
            Assert.assertArrayEquals((Object[])new Object[]{"b", "c"}, (Object[])((Object[])valueSelector.getObject()));
            cursor.advance();
            Assert.assertArrayEquals((Object[])new Object[]{"d", "e"}, (Object[])((Object[])valueSelector.getObject()));
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootVariant() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, VARIANT_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, VARIANT_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, VARIANT_COL, 3.3));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, VARIANT_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, VARIANT_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(VARIANT_COL, VARIANT_COL, ColumnType.STRING);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
            DimensionSelector dimensionSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)dimensionSpec);
            Assert.assertEquals((Object)"a", (Object)valueSelector.getObject());
            Assert.assertEquals((Object)"a", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)2L, (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((Object)"2", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)3.3, (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((Object)"3.3", (Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertNull((Object)dimensionSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertNull((Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryNested() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerV4Test.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, NESTED_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, NESTED_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, NESTED_COL, ImmutableMap.of((Object)"x", (Object)1.1, (Object)"y", (Object)2L)));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, NESTED_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, NESTED_COL, null));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(NESTED_COL, NESTED_COL, ColumnType.STRING);
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
            Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerV4Test.lambda$testNestedColumnIndexerSchemaDiscoveryNested$1(cursor, (DimensionSpec)dimensionSpec));
            Assert.assertEquals((Object)StructuredData.wrap((Object)"a"), (Object)valueSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)StructuredData.wrap((Object)2L), (Object)valueSelector.getObject());
            cursor.advance();
            Assert.assertEquals((Object)StructuredData.wrap((Object)ImmutableMap.of((Object)"x", (Object)1.1, (Object)"y", (Object)2L)), (Object)valueSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
            cursor.advance();
            Assert.assertNull((Object)valueSelector.getObject());
        }
    }

    @Nonnull
    private static IncrementalIndex makeIncrementalIndex(long minTimestamp) {
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(IncrementalIndexSchema.builder().withMinTimestamp(minTimestamp).withTimestampSpec(new TimestampSpec(TIME_COL, "millis", null)).withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(true).build()).withRollup(false).build()).setMaxRowCount(1000).build();
        return index;
    }

    private MapBasedInputRow makeInputRow(long timestamp, boolean explicitNull, Object ... kv) {
        Map<String, Object> event = TestHelper.makeMap(explicitNull, kv);
        event.put(TIME_COL, timestamp);
        return new MapBasedInputRow(timestamp, (List)ImmutableList.copyOf(event.keySet()), event);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$1(Cursor cursor, DimensionSpec dimensionSpec) throws Throwable {
        cursor.getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$0(Cursor cursor, DimensionSpec dimensionSpec) throws Throwable {
        cursor.getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }
}

