/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.druid.segment.FloatWrappingDimensionSelector;
import org.apache.druid.segment.LongWrappingDimensionSelector;
import org.apache.druid.segment.TestNullableDoubleColumnSelector;
import org.apache.druid.segment.TestNullableFloatColumnSelector;
import org.apache.druid.segment.TestNullableLongColumnSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class WrappingDimensionSelectorTest
extends InitializedNullHandlingTest {
    @Test
    public void testLongWrappingDimensionSelector() {
        Long[] vals = new Long[]{24L, null, 50L, 0L, -60L};
        TestNullableLongColumnSelector lngSelector = new TestNullableLongColumnSelector(vals);
        LongWrappingDimensionSelector lngWrapSelector = new LongWrappingDimensionSelector((BaseLongColumnValueSelector)lngSelector, null);
        Assert.assertEquals((long)24L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"24", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertTrue((boolean)lngSelector.isNull());
        Assert.assertNull((Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)50L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"50", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)0L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"0", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)-60L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"-60", (Object)lngWrapSelector.getValue());
    }

    @Test
    public void testDoubleWrappingDimensionSelector() {
        Double[] vals = new Double[]{32.0, null, 5.0, 0.0, -45.0};
        TestNullableDoubleColumnSelector dblSelector = new TestNullableDoubleColumnSelector(vals);
        DoubleWrappingDimensionSelector dblWrapSelector = new DoubleWrappingDimensionSelector((BaseDoubleColumnValueSelector)dblSelector, null);
        Assert.assertEquals((double)32.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"32.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertTrue((boolean)dblSelector.isNull());
        Assert.assertNull((Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)5.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"5.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)0.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"0.0", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)-45.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"-45.0", (Object)dblWrapSelector.getValue());
    }

    @Test
    public void testFloatWrappingDimensionSelector() {
        Float[] vals = new Float[]{Float.valueOf(32.0f), null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(-45.0f)};
        TestNullableFloatColumnSelector flSelector = new TestNullableFloatColumnSelector(vals);
        FloatWrappingDimensionSelector flWrapSelector = new FloatWrappingDimensionSelector((BaseFloatColumnValueSelector)flSelector, null);
        Assert.assertEquals((float)32.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"32.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertTrue((boolean)flSelector.isNull());
        Assert.assertNull((Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)5.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"5.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)0.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"0.0", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)-45.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"-45.0", (Object)flWrapSelector.getValue());
    }

    @Test
    public void testLongWrappingDimensionSelectorExtractionFn() {
        Long[] vals = new Long[]{24L, null, 50L, 0L, -60L};
        TestNullableLongColumnSelector lngSelector = new TestNullableLongColumnSelector(vals);
        TestExtractionFn extractionFn = new TestExtractionFn();
        LongWrappingDimensionSelector lngWrapSelector = new LongWrappingDimensionSelector((BaseLongColumnValueSelector)lngSelector, (ExtractionFn)extractionFn);
        Assert.assertEquals((long)24L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"24x", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertTrue((boolean)lngSelector.isNull());
        Assert.assertEquals((Object)"nullx", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)50L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"50x", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)0L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"0x", (Object)lngWrapSelector.getValue());
        lngSelector.increment();
        Assert.assertEquals((long)-60L, (long)lngSelector.getLong());
        Assert.assertEquals((Object)"-60x", (Object)lngWrapSelector.getValue());
    }

    @Test
    public void testDoubleWrappingDimensionSelectorExtractionFn() {
        Double[] vals = new Double[]{32.0, null, 5.0, 0.0, -45.0};
        TestNullableDoubleColumnSelector dblSelector = new TestNullableDoubleColumnSelector(vals);
        TestExtractionFn extractionFn = new TestExtractionFn();
        DoubleWrappingDimensionSelector dblWrapSelector = new DoubleWrappingDimensionSelector((BaseDoubleColumnValueSelector)dblSelector, (ExtractionFn)extractionFn);
        Assert.assertEquals((double)32.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"32.0x", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertTrue((boolean)dblSelector.isNull());
        Assert.assertEquals((Object)"nullx", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)5.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"5.0x", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)0.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"0.0x", (Object)dblWrapSelector.getValue());
        dblSelector.increment();
        Assert.assertEquals((double)-45.0, (double)dblSelector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)"-45.0x", (Object)dblWrapSelector.getValue());
    }

    @Test
    public void testFloatWrappingDimensionSelectorExtractionFn() {
        Float[] vals = new Float[]{Float.valueOf(32.0f), null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(-45.0f)};
        TestNullableFloatColumnSelector flSelector = new TestNullableFloatColumnSelector(vals);
        TestExtractionFn extractionFn = new TestExtractionFn();
        FloatWrappingDimensionSelector flWrapSelector = new FloatWrappingDimensionSelector((BaseFloatColumnValueSelector)flSelector, (ExtractionFn)extractionFn);
        Assert.assertEquals((float)32.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"32.0x", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertTrue((boolean)flSelector.isNull());
        Assert.assertEquals((Object)"nullx", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)5.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"5.0x", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)0.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"0.0x", (Object)flWrapSelector.getValue());
        flSelector.increment();
        Assert.assertEquals((float)-45.0f, (float)flSelector.getFloat(), (float)0.0f);
        Assert.assertEquals((Object)"-45.0x", (Object)flWrapSelector.getValue());
    }

    private static class TestExtractionFn
    extends DimExtractionFn {
        private TestExtractionFn() {
        }

        public byte[] getCacheKey() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String apply(@Nullable String value) {
            return value + "x";
        }

        public boolean preservesOrdering() {
            return false;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }
    }
}

