/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.junit.Assert;
import org.junit.Test;

public class StringEncodingStrategyTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testUtf8Serde() throws JsonProcessingException {
        StringEncodingStrategy.Utf8 utf8 = new StringEncodingStrategy.Utf8();
        String there = JSON_MAPPER.writeValueAsString((Object)utf8);
        StringEncodingStrategy andBackAgain = (StringEncodingStrategy)JSON_MAPPER.readValue(there, StringEncodingStrategy.class);
        Assert.assertEquals((Object)utf8, (Object)andBackAgain);
    }

    @Test
    public void testFrontCodedDefaultSerde() throws JsonProcessingException {
        StringEncodingStrategy.FrontCoded frontCoded = new StringEncodingStrategy.FrontCoded(null, null);
        String there = JSON_MAPPER.writeValueAsString((Object)frontCoded);
        StringEncodingStrategy andBackAgain = (StringEncodingStrategy)JSON_MAPPER.readValue(there, StringEncodingStrategy.class);
        Assert.assertEquals((Object)frontCoded, (Object)andBackAgain);
        Assert.assertEquals((long)4L, (long)((StringEncodingStrategy.FrontCoded)andBackAgain).getBucketSize());
        Assert.assertEquals((long)0L, (long)((StringEncodingStrategy.FrontCoded)andBackAgain).getFormatVersion());
        Assert.assertEquals((long)0L, (long)0L);
    }

    @Test
    public void testFrontCodedFormatSerde() throws JsonProcessingException {
        StringEncodingStrategy.FrontCoded frontCodedV0 = new StringEncodingStrategy.FrontCoded(Integer.valueOf(16), Byte.valueOf((byte)0));
        String there = JSON_MAPPER.writeValueAsString((Object)frontCodedV0);
        StringEncodingStrategy andBackAgain = (StringEncodingStrategy)JSON_MAPPER.readValue(there, StringEncodingStrategy.class);
        Assert.assertEquals((Object)frontCodedV0, (Object)andBackAgain);
        StringEncodingStrategy.FrontCoded frontCodedV1 = new StringEncodingStrategy.FrontCoded(Integer.valueOf(8), Byte.valueOf((byte)1));
        there = JSON_MAPPER.writeValueAsString((Object)frontCodedV1);
        andBackAgain = (StringEncodingStrategy)JSON_MAPPER.readValue(there, StringEncodingStrategy.class);
        Assert.assertEquals((Object)frontCodedV1, (Object)andBackAgain);
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(StringEncodingStrategy.Utf8.class).usingGetClass().verify();
        EqualsVerifier.forClass(StringEncodingStrategy.FrontCoded.class).usingGetClass().verify();
    }
}

