/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.filter.ArrayContainsElementFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class ArrayContainsElementFilterTests {

    public static class ArrayContainsElementFilterNonParameterizedTests
    extends InitializedNullHandlingTest {
        @Test
        public void testSerde() throws JsonProcessingException {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            ArrayContainsElementFilter filter = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"hello", null);
            String s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)1L, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)1, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.DOUBLE, (Object)111.111, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1234.0f), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, Arrays.asList("a", "b", null, "c"), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, null, 2L, 3L}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, Arrays.asList(1L, null, 2L, 3L), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, null, 3.1}, null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, Arrays.asList(1.1, 2.1, null, 3.1), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
            filter = new ArrayContainsElementFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, ArrayContainsElementFilter.class));
        }

        @Test
        public void testRewrite() {
            ArrayContainsElementFilter filter = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"hello", null);
            Filter rewrite = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"x", (Object)"y"));
            ArrayContainsElementFilter expected = new ArrayContainsElementFilter("y", ColumnType.STRING, (Object)"hello", null);
            Assert.assertEquals((Object)expected, (Object)rewrite);
        }

        @Test
        public void testGetCacheKey() {
            ArrayContainsElementFilter f1 = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"hello", null);
            ArrayContainsElementFilter f1_2 = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"hello", null);
            ArrayContainsElementFilter f2 = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"world", null);
            ArrayContainsElementFilter f3 = new ArrayContainsElementFilter("x", ColumnType.STRING, (Object)"hello", new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)1L, null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)1, null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)2L, null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.LONG, (Object)1L, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE, (Object)1.1, null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE, (Object)1.1, null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE, (Object)2.2, null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE, (Object)1.1, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(2.2f), null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, Arrays.asList("a", "b", null, "c"), null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", null, "c"}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, 200L, null, 300L}, null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, Arrays.asList(100L, 200L, null, 300L), null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, null, 200L, 300L}, null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{100L, 200L, null, 300L}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, null, 20.0002, 300.0003}, null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, Arrays.asList(1.001, null, 20.0002, 300.0003), null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, 20.0002, 300.0003, null}, null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.001, null, 20.0002, 300.0003}, new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            BuiltInTypesModule.registerHandlersAndSerde();
            f1 = new ArrayContainsElementFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            f1_2 = new ArrayContainsElementFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), null);
            f2 = new ArrayContainsElementFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4)), null);
            f3 = new ArrayContainsElementFilter("x", ColumnType.NESTED_DATA, (Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
        }

        @Test
        public void testInvalidParameters() {
            Throwable t = Assert.assertThrows(DruidException.class, () -> new ArrayContainsElementFilter(null, ColumnType.STRING, null, null));
            Assert.assertEquals((Object)"Invalid array_contains filter, column cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new ArrayContainsElementFilter("dim0", null, null, null));
            Assert.assertEquals((Object)"Invalid array_contains filter on column [dim0], elementMatchValueType cannot be null", (Object)t.getMessage());
        }

        @Test
        public void test_equals() {
            EqualsVerifier.forClass(ArrayContainsElementFilter.class).usingGetClass().withNonnullFields(new String[]{"column", "elementMatchValueType", "elementMatchValueEval", "elementMatchValue", "predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).withPrefabValues(ColumnType.class, (Object)ColumnType.STRING, (Object)ColumnType.DOUBLE).withIgnoredFields(new String[]{"predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown", "elementMatchValue"}).verify();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ArrayContainsElementFilterTest
    extends BaseFilterTest {
        public ArrayContainsElementFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
            super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
        }

        @AfterClass
        public static void tearDown() throws Exception {
            BaseFilterTest.tearDown(ArrayContainsElementFilterTest.class.getName());
        }

        @Test
        public void testArrayStringColumn() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, (Object)"c", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, null, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING, null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4"));
        }

        @Test
        public void testArrayLongColumn() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG, (Object)2L, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG, (Object)2L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG, null, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG, null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.DOUBLE, (Object)2.0, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.STRING, (Object)"2", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
        }

        @Test
        public void testArrayDoubleColumn() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.DOUBLE, (Object)2.2, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.DOUBLE, (Object)2.2, null)), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.STRING, (Object)"2.2", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.DOUBLE, null, null), (List<String>)ImmutableList.of((Object)"2"));
        }

        @Test
        public void testArrayStringColumnContainsArrays() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testArrayLongColumnContainsArrays() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        }

        @Test
        public void testArrayDoubleColumnContainsArrays() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        }

        @Test
        public void testScalarColumnContains() {
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"c"), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("s0", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"c"), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE, (Object)10.1, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE, (Object)120.0245, null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE, (Object)765.432, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE, (Object)765.431, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{10.1}, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("d0", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{10.1, 120.0245}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG, (Object)100L, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG, (Object)40L, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG, (Object)9001L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG, (Object)9000L, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)9001L), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("l0", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)40L, (Object)9001L), null), (List<String>)ImmutableList.of());
        }

        @Test
        public void testArrayContainsNestedArray() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatchesSkipVectorize((DimFilter)new ArrayContainsElementFilter("nestedArrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new ArrayContainsElementFilter("nestedArrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L}, null), (List<String>)ImmutableList.of());
        }

        @Test
        public void testArrayContainsMvd() {
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("dim2", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            if (this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("dim2", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4"));
                this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("dim2", ColumnType.STRING, null, null), (List<String>)ImmutableList.of());
            } else {
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("dim2", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
                this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("dim2", ColumnType.STRING, null, null), (List<String>)ImmutableList.of());
            }
        }

        @Test
        public void testNestedArrayStringColumn() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, (Object)"a", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, (Object)"c", null)), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, null, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING, null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4"));
        }

        @Test
        public void testNestedArrayLongColumn() {
            Assume.assumeFalse((this.testName.contains("frame (columnar)") || this.testName.contains("rowBasedWithoutTypeSignature") ? 1 : 0) != 0);
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG, (Object)2L, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG, (Object)2L, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG, null, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG, null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.DOUBLE, (Object)2.0, null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.STRING, (Object)"2", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
        }

        @Test
        public void testNestedArrayDoubleColumn() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.DOUBLE, (Object)2.2, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.DOUBLE, (Object)2.2, null)), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.STRING, (Object)"2.2", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.DOUBLE, null, null), (List<String>)ImmutableList.of((Object)"2"));
        }

        @Test
        public void testNestedArrayStringColumnContainsArrays() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayString", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testNestedArrayLongColumnContainsArrays() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayLong", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        }

        @Test
        public void testNestedArrayDoubleColumnContainsArrays() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new ArrayContainsElementFilter("nested.arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        }

        @Test
        public void testNestedScalarColumnContains() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING, (Object)"a", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING, (Object)"b", null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING, (Object)"c", null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING, (Object)"noexist", null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"c"), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.s0", ColumnType.STRING_ARRAY, (Object)ImmutableList.of((Object)"a", (Object)"c"), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE, (Object)10.1, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE, (Object)120.0245, null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE, (Object)765.432, null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE, (Object)765.431, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{10.1}, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.d0", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{10.1, 120.0245}, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG, (Object)100L, null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG, (Object)40L, null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG, (Object)9001L, null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG, (Object)9000L, null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)9001L), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new ArrayContainsElementFilter("nested.l0", ColumnType.LONG_ARRAY, (Object)ImmutableList.of((Object)40L, (Object)9001L), null), (List<String>)ImmutableList.of());
        }
    }
}

