/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.LikeFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LikeFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2"))).build()));
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("dim0", ColumnType.STRING).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).build();
    private static final List<InputRow> ROWS = ImmutableList.of((Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "0", "", ""), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "1", "foo", "aaa"), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "2", "foobar", "aab"), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "3", "bar", null), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "4", "foobarbaz", "abb"), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "5", "foo%bar", "bbb"), (Object)LikeFilterTest.makeSchemaRow(PARSER, ROW_SIGNATURE, "6", "new\nline", "bbz"));

    public LikeFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(LikeFilterTest.class.getName());
    }

    @Test
    public void testExactMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "bar", null, null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "bar", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "bbb", null, null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "bbb", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6"));
    }

    @Test
    public void testExactMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "@bar", "@", null), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testExactMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "bar", null, (ExtractionFn)new SubstringDimExtractionFn(3, Integer.valueOf(3))), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "bar", null, (ExtractionFn)new SubstringDimExtractionFn(3, Integer.valueOf(3)))), (List<String>)ImmutableList.of((Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "bbb", null, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(3))), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "bbb", null, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(3)))), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"6"));
    }

    @Test
    public void testPrefixMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "foo%", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "foo%", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "aa%", null, null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "aa%", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"4", (Object)"5", (Object)"6"));
    }

    @Test
    public void testPrefixMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "foo@%%", "@", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testPrefixMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "a%", null, (ExtractionFn)new SubstringDimExtractionFn(1, null)), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "a%", null, (ExtractionFn)new SubstringDimExtractionFn(1, null))), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "a%", null, (ExtractionFn)new SubstringDimExtractionFn(1, null)), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "a%", null, (ExtractionFn)new SubstringDimExtractionFn(1, null))), (List<String>)ImmutableList.of((Object)"4", (Object)"5", (Object)"6"));
    }

    @Test
    public void testWildcardMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%oba%", null, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "%oba%", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "%b%", null, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "%b%", null, null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
    }

    @Test
    public void testMatchEmptyString() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "", null, null), (List<String>)ImmutableList.of((Object)"0"));
    }

    @Test
    public void testMatchEmptyStringWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "", null, (ExtractionFn)new SubstringDimExtractionFn(100, Integer.valueOf(1))), (List<String>)ImmutableList.of());
    }

    @Test
    public void testNonNullableExtractionFnMissingColumn() {
        LookupExtractionFn extractionFn = new LookupExtractionFn((LookupExtractor)new MapLookupExtractor((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), false), false, "replaced", Boolean.valueOf(false), Boolean.valueOf(false));
        LikeDimFilter filter = new LikeDimFilter("fake", "__DOESNT_EXIST__%", null, (ExtractionFn)extractionFn);
        this.assertFilterMatches((DimFilter)filter, (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)filter), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
    }

    @Test
    public void testWildcardMatchWithEscape() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%@%ba%", "@", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testWildcardMatchEverything() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%", "@", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim1", "%", "@", null)), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim2", "%", "@", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new LikeDimFilter("dim2", "%", "@", null)), (List<String>)ImmutableList.of());
    }

    @Test
    public void testPrefixAndSuffixMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "f%r", null, null), (List<String>)ImmutableList.of((Object)"2", (Object)"5"));
    }

    @Test
    public void testUnderscoreMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "f_o", null, null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testEscapeEscapingItself() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "foooo", "o", null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSuffixMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%ar", null, (ExtractionFn)new SubstringDimExtractionFn(3, Integer.valueOf(3))), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
    }

    @Test
    public void testNewlineMatch() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "ne%", null, null), (List<String>)ImmutableList.of((Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%ine", null, null), (List<String>)ImmutableList.of((Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "new_line", null, null), (List<String>)ImmutableList.of((Object)"6"));
    }

    @Test
    public void testNewlineMatchWithExtractionFn() {
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "e%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(100))), (List<String>)ImmutableList.of((Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "%ine", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(100))), (List<String>)ImmutableList.of((Object)"6"));
        this.assertFilterMatches((DimFilter)new LikeDimFilter("dim1", "ew_line", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(100))), (List<String>)ImmutableList.of((Object)"6"));
    }

    @Test
    public void testListFilteredVirtualColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)new LikeDimFilter("allow-dim0", "1%", null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)new LikeDimFilter("allow-dim0", "3%", null, null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new LikeDimFilter("allow-dim0", "%3", null, null), (List<String>)ImmutableList.of((Object)"3"));
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = new LikeDimFilter("dim0", "e%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(100))).toFilter();
        Filter filter2 = new LikeDimFilter("dim1", "e%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(100))).toFilter();
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        Throwable t = Assert.assertThrows(IAE.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
        Assert.assertEquals((Object)"Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0", (Object)t.getMessage());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(LikeFilter.class).usingGetClass().withNonnullFields(new String[]{"dimension", "likeMatcher"}).verify();
    }
}

