/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexTest
extends InitializedNullHandlingTest {
    public final IncrementalIndexCreator indexCreator;
    private final String mode;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexTest(String indexType, String mode) throws JsonProcessingException {
        this.mode = mode;
        DimensionsSpec dimensions = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string"), new FloatDimensionSchema("float"), new LongDimensionSchema("long"), new DoubleDimensionSchema("double"), new StringDimensionSchema("bool_string"), new LongDimensionSchema("bool_long"), new AutoTypeColumnSchema("bool_auto", null), new AutoTypeColumnSchema("array_string", ColumnType.STRING_ARRAY), new AutoTypeColumnSchema("array_double", ColumnType.DOUBLE_ARRAY), new AutoTypeColumnSchema("array_long", ColumnType.LONG_ARRAY), new AutoTypeColumnSchema("nested", null)));
        AggregatorFactory[] metrics = new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("cnt"), (DimFilter)new SelectorDimFilter("billy", "A", null))};
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withDimensionsSpec(dimensions).withMetrics(metrics).withRollup("rollup".equals(mode)).build();
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setIndexSchema(schema).setMaxRowCount(1000000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}, {1}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.indexTypeCartesianProduct(new Collection[]{ImmutableList.of((Object)"rollup", (Object)"plain")});
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensions() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensionsFirstOccurrence() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void controlTest() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"C", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void testUnparseableNumerics() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        IncrementalIndexAddResult result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"19.0", (Object)"long", (Object)"asdj", (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=asdj, double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=asdj, double=21.0}], exceptions: [Could not convert value [asdj] to long for dimension [long].]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"aaa", (Object)"long", (Object)20, (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=aaa, long=20, double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=aaa, long=20, double=21.0}], exceptions: [Could not convert value [aaa] to float for dimension [float].]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)19.0, (Object)"long", (Object)20, (Object)"double", (Object)"")));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=20, double=}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=20, double=}], exceptions: [Could not convert value [] to double for dimension [double].]", (Object)result.getParseException().getMessage());
    }

    @Test
    public void testMultiValuedNumericDimensions() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        IncrementalIndexAddResult result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"19.0", (Object)"long", Arrays.asList(10L, 5L), (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=[10, 5], double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=[10, 5], double=21.0}], exceptions: [Could not ingest value [[10, 5]] as long for dimension [long]. A long column cannot have multiple values in the same row.]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", Arrays.asList(Float.valueOf(10.0f), Float.valueOf(5.0f)), (Object)"long", (Object)20, (Object)"double", (Object)21.0)));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=[10.0, 5.0], long=20, double=21.0}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=[10.0, 5.0], long=20, double=21.0}], exceptions: [Could not ingest value [[10.0, 5.0]] as float for dimension [float]. A float column cannot have multiple values in the same row.]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)19.0, (Object)"long", (Object)20, (Object)"double", Arrays.asList(10.0, 5.0))));
        Assert.assertEquals(UnparseableColumnsParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"{string=A, float=19.0, long=20, double=[10.0, 5.0]}", (Object)result.getParseException().getInput());
        Assert.assertEquals((Object)"Found unparseable columns in row: [{string=A, float=19.0, long=20, double=[10.0, 5.0]}], exceptions: [Could not ingest value [[10.0, 5.0]] as double for dimension [double]. A double column cannot have multiple values in the same row.]", (Object)result.getParseException().getMessage());
    }

    @Test
    public void sameRow() throws IndexSizeExceededException {
        MapBasedInputRow row = new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B"));
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        index.add((InputRow)row);
        index.add((InputRow)row);
        index.add((InputRow)row);
        Assert.assertEquals((long)("rollup".equals(this.mode) ? 1L : 3L), (long)index.numRows());
    }

    @Test
    public void testTypeHandling() throws IndexSizeExceededException {
        IncrementalIndex index = this.indexCreator.createIndex(new Object[0]);
        List<String> dims = Arrays.asList("string", "float", "long", "double", "bool_string", "bool_long", "bool_auto", "array_string", "array_long", "array_double", "nested");
        IncrementalIndexAddResult result = index.add((InputRow)new MapBasedInputRow(0L, dims, (Map)ImmutableMap.builder().put((Object)"string", (Object)"a").put((Object)"float", (Object)1.0).put((Object)"long", (Object)1).put((Object)"double", (Object)1.0).put((Object)"bool_string", (Object)true).put((Object)"bool_long", (Object)true).put((Object)"bool_auto", (Object)true).put((Object)"array_string", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).put((Object)"array_long", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3)).put((Object)"array_double", (Object)ImmutableList.of((Object)1.1, (Object)2.2, (Object)3.3)).put((Object)"nested", (Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)ImmutableList.of((Object)"a", (Object)"b"))).build()));
        Assert.assertNull((Object)result.getParseException());
        result = index.add((InputRow)new MapBasedInputRow(60000L, dims, (Map)ImmutableMap.builder().put((Object)"string", (Object)"b").put((Object)"float", (Object)2.0).put((Object)"long", (Object)2).put((Object)"double", (Object)2.0).put((Object)"bool_string", (Object)false).put((Object)"bool_long", (Object)false).put((Object)"bool_auto", (Object)false).put((Object)"array_string", (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f")).put((Object)"array_long", (Object)ImmutableList.of((Object)4, (Object)5, (Object)6)).put((Object)"array_double", (Object)ImmutableList.of((Object)4.4, (Object)5.5, (Object)6.6)).put((Object)"nested", (Object)ImmutableMap.of((Object)"x", (Object)2, (Object)"y", (Object)ImmutableList.of((Object)"c", (Object)"d"))).build()));
        Assert.assertNull((Object)result.getParseException());
        Assert.assertEquals((Object)ColumnType.STRING, (Object)index.getColumnCapabilities("string").toColumnType());
        Assert.assertEquals((Object)ColumnType.FLOAT, (Object)index.getColumnCapabilities("float").toColumnType());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.getColumnCapabilities("long").toColumnType());
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)index.getColumnCapabilities("double").toColumnType());
        Assert.assertEquals((Object)ColumnType.STRING, (Object)index.getColumnCapabilities("bool_string").toColumnType());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.getColumnCapabilities("bool_long").toColumnType());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.getColumnCapabilities("bool_auto").toColumnType());
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)index.getColumnCapabilities("array_string").toColumnType());
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)index.getColumnCapabilities("array_long").toColumnType());
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)index.getColumnCapabilities("array_double").toColumnType());
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)index.getColumnCapabilities("nested").toColumnType());
        Iterator rowIterator = index.iterator();
        Row row = (Row)rowIterator.next();
        Assert.assertEquals((Object)"a", (Object)row.getRaw("string"));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)row.getRaw("float"));
        Assert.assertEquals((Object)1L, (Object)row.getRaw("long"));
        Assert.assertEquals((Object)1.0, (Object)row.getRaw("double"));
        Assert.assertEquals((Object)"true", (Object)row.getRaw("bool_string"));
        Assert.assertEquals((Object)1L, (Object)row.getRaw("bool_long"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)true), (Object)row.getRaw("bool_auto"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{"a", "b", "c"}), (Object)row.getRaw("array_string"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{1L, 2L, 3L}), (Object)row.getRaw("array_long"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{1.1, 2.2, 3.3}), (Object)row.getRaw("array_double"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)ImmutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)ImmutableList.of((Object)"a", (Object)"b"))), (Object)row.getRaw("nested"));
        row = (Row)rowIterator.next();
        Assert.assertEquals((Object)"b", (Object)row.getRaw("string"));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)row.getRaw("float"));
        Assert.assertEquals((Object)2L, (Object)row.getRaw("long"));
        Assert.assertEquals((Object)2.0, (Object)row.getRaw("double"));
        Assert.assertEquals((Object)"false", (Object)row.getRaw("bool_string"));
        Assert.assertEquals((Object)0L, (Object)row.getRaw("bool_long"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)false), (Object)row.getRaw("bool_auto"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{"d", "e", "f"}), (Object)row.getRaw("array_string"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{4L, 5L, 6L}), (Object)row.getRaw("array_long"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)new Object[]{4.4, 5.5, 6.6}), (Object)row.getRaw("array_double"));
        Assert.assertEquals((Object)StructuredData.wrap((Object)ImmutableMap.of((Object)"x", (Object)2, (Object)"y", (Object)ImmutableList.of((Object)"c", (Object)"d"))), (Object)row.getRaw("nested"));
    }
}

