/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.junit.Assert;
import org.junit.Test;

public class JoinConditionAnalysisTest {
    private static final String PREFIX = "j.";

    @Test
    public void test_forExpression_simple() {
        String expression = "x == \"j.y\"";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("x == \"j.y\"");
        Assert.assertEquals((Object)"x == \"j.y\"", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"x", (Object)"y")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"y"));
    }

    @Test
    public void test_forExpression_simpleFlipped() {
        String expression = "\"j.y\" == x";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("\"j.y\" == x");
        Assert.assertEquals((Object)"\"j.y\" == x", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"x", (Object)"y")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"y"));
    }

    @Test
    public void test_forExpression_leftFunction() {
        String expression = "x + y == \"j.z\"";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("x + y == \"j.z\"");
        Assert.assertEquals((Object)"x + y == \"j.z\"", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"(+ x y)", (Object)"z")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"z"));
    }

    @Test
    public void test_forExpression_rightFunction() {
        String expression = "\"j.x\" + \"j.y\" == z";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("\"j.x\" + \"j.y\" == z");
        Assert.assertEquals((Object)"\"j.x\" + \"j.y\" == z", (Object)analysis.getOriginalExpression());
        Assert.assertFalse((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"(== (+ j.x j.y) z)"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertTrue((boolean)analysis.getRightEquiConditionKeys().isEmpty());
    }

    @Test
    public void test_forExpression_mixedFunction() {
        String expression = "x + \"j.y\" == \"j.z\"";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("x + \"j.y\" == \"j.z\"");
        Assert.assertEquals((Object)"x + \"j.y\" == \"j.z\"", (Object)analysis.getOriginalExpression());
        Assert.assertFalse((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"(== (+ x j.y) j.z)"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertTrue((boolean)analysis.getRightEquiConditionKeys().isEmpty());
    }

    @Test
    public void test_forExpression_trueConstant() {
        String expression = "1 + 1";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("1 + 1");
        Assert.assertEquals((Object)"1 + 1", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertTrue((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"2"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertTrue((boolean)analysis.getRightEquiConditionKeys().isEmpty());
    }

    @Test
    public void test_forExpression_falseConstant() {
        String expression = "0";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("0");
        Assert.assertEquals((Object)"0", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertTrue((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"0"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertTrue((boolean)analysis.getRightEquiConditionKeys().isEmpty());
    }

    @Test
    public void test_forExpression_onlyLeft() {
        String expression = "x == 1";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("x == 1");
        Assert.assertEquals((Object)"x == 1", (Object)analysis.getOriginalExpression());
        Assert.assertFalse((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"(== x 1)"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertTrue((boolean)analysis.getRightEquiConditionKeys().isEmpty());
    }

    @Test
    public void test_forExpression_onlyRight() {
        String expression = "\"j.x\" == 1";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("\"j.x\" == 1");
        Assert.assertEquals((Object)"\"j.x\" == 1", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"1", (Object)"x")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"x"));
    }

    @Test
    public void test_forExpression_andOfThreeConditions() {
        String expression = "(x == \"j.y\") && (x + y == \"j.z\") && (z == \"j.zz\")";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("(x == \"j.y\") && (x + y == \"j.z\") && (z == \"j.zz\")");
        Assert.assertEquals((Object)"(x == \"j.y\") && (x + y == \"j.z\") && (z == \"j.zz\")", (Object)analysis.getOriginalExpression());
        Assert.assertTrue((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"x", (Object)"y"), (Object)Pair.of((Object)"(+ x y)", (Object)"z"), (Object)Pair.of((Object)"z", (Object)"zz")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of(), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"y", (Object)"z", (Object)"zz"));
    }

    @Test
    public void test_forExpression_mixedAndWithOr() {
        String expression = "(x == \"j.y\") && ((x + y == \"j.z\") || (z == \"j.zz\"))";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("(x == \"j.y\") && ((x + y == \"j.z\") || (z == \"j.zz\"))");
        Assert.assertEquals((Object)"(x == \"j.y\") && ((x + y == \"j.z\") || (z == \"j.zz\"))", (Object)analysis.getOriginalExpression());
        Assert.assertFalse((boolean)analysis.canHashJoin());
        Assert.assertFalse((boolean)analysis.isAlwaysTrue());
        Assert.assertFalse((boolean)analysis.isAlwaysFalse());
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"x", (Object)"y")), JoinConditionAnalysisTest.equalitiesToPairs(analysis.getEquiConditions()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"(|| (== (+ x y) j.z) (== z j.zz))"), JoinConditionAnalysisTest.exprsToStrings(analysis.getNonEquiConditions()));
        Assert.assertEquals((Object)analysis.getRightEquiConditionKeys(), (Object)ImmutableSet.of((Object)"y"));
    }

    @Test
    public void test_getRequiredColumns() {
        String expression = "(x == \"j.y\") && ((x + y == \"j.z\") || (z == \"j.zz\"))";
        JoinConditionAnalysis analysis = JoinConditionAnalysisTest.analyze("(x == \"j.y\") && ((x + y == \"j.z\") || (z == \"j.zz\"))");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"j.y", (Object)"y", (Object)"j.z", (Object)"z", (Object)"j.zz", (Object[])new String[0]), (Object)analysis.getRequiredColumns());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(JoinConditionAnalysis.class).usingGetClass().withIgnoredFields(new String[]{"equiConditions", "nonEquiConditions", "requiredColumns", "isAlwaysTrue", "isAlwaysFalse", "canHashJoin", "rightKeyColumns"}).verify();
    }

    private static JoinConditionAnalysis analyze(String expression) {
        return JoinConditionAnalysis.forExpression((String)expression, (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static Pair<String, String> equalityToPair(Equality equality) {
        return Pair.of((Object)equality.getLeftExpr().toString(), (Object)equality.getRightColumn());
    }

    private static List<Pair<String, String>> equalitiesToPairs(List<Equality> equalities) {
        return equalities.stream().map(JoinConditionAnalysisTest::equalityToPair).collect(Collectors.toList());
    }

    private static List<String> exprsToStrings(List<Expr> exprs) {
        return exprs.stream().map(String::valueOf).collect(Collectors.toList());
    }
}

