/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.ByteWriterTestHelper;
import org.apache.druid.segment.serde.cell.BytesReadWriteTest;
import org.apache.druid.segment.serde.cell.BytesWriterBuilder;
import org.apache.druid.segment.serde.cell.TestCaseResult;
import org.apache.druid.segment.serde.cell.TestCasesConfig;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BytesReadWriteTestBase
implements BytesReadWriteTest {
    protected final BytesWriterBuilder bytesWriterBuilder;
    private final TestCasesConfig<BytesReadWriteTest> testCases;
    private final ByteWriterTestHelper.ValidationFunctionBuilder validationFunctionBuilder;
    private ByteWriterTestHelper testHelper;

    protected BytesReadWriteTestBase(BytesWriterBuilder bytesWriterBuilder, ByteWriterTestHelper.ValidationFunctionBuilder validationFunctionBuilder, TestCasesConfig<BytesReadWriteTest> testCases) {
        this.testCases = testCases;
        this.bytesWriterBuilder = bytesWriterBuilder;
        this.validationFunctionBuilder = validationFunctionBuilder;
    }

    protected ByteWriterTestHelper getTestHelper() {
        return this.testHelper;
    }

    @Before
    public void setup() {
        this.testHelper = new ByteWriterTestHelper(this.bytesWriterBuilder, this.validationFunctionBuilder);
    }

    @Override
    @Test
    public void testSingleWriteBytes() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer payload = this.testHelper.generateBufferWithLongs(1024);
        this.runTestWithExceptionHandling(Collections.singletonList(payload), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testSingleMultiBlockWriteBytes() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer payload = this.testHelper.generateBufferWithLongs(262144);
        this.runTestWithExceptionHandling(Collections.singletonList(payload), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testSingleMultiBlockWriteBytesWithPrelude() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer payload1 = this.testHelper.generateBufferWithLongs(1024);
        ByteBuffer payload2 = this.testHelper.generateBufferWithLongs(262144);
        this.runTestWithExceptionHandling(Arrays.asList(payload1, payload2), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testEmptyByteArray() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer payload = ByteBuffer.wrap(new byte[0]);
        this.runTestWithExceptionHandling(Collections.singletonList(payload), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testNull() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        TestCaseResult testCaseResult = this.testCases.currentTestValue();
        this.runTestWithExceptionHandling(Collections.singletonList(null), testCaseResult);
    }

    @Override
    @Test
    public void testSingleLong() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer payload = this.testHelper.generateBufferWithLongs(1);
        this.runTestWithExceptionHandling(Collections.singletonList(payload), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testVariableSizedCompressablePayloads() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        List<ByteBuffer> bufferList = this.testHelper.generateRaggedPayloadBuffer(100, 1024, 10, 0, 0, 10);
        this.runTestWithExceptionHandling(bufferList, this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testOutliersInNormalDataUncompressablePayloads() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        List<ByteBuffer> bufferList = this.testHelper.generateRaggedPayloadBuffer(100, 1024, 10, 65536, 2);
        this.runTestWithExceptionHandling(bufferList, this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testOutliersInNormalDataCompressablePayloads() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        List<ByteBuffer> bufferList = this.testHelper.generateRaggedPayloadBuffer(100, 1024, 10, 65536, 2, 10);
        this.runTestWithExceptionHandling(bufferList, this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testSingleUncompressableBlock() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer byteBuffer = this.testHelper.generateIntPayloads(16384);
        Assert.assertEquals((long)65536L, (long)byteBuffer.limit());
        this.runTestWithExceptionHandling(Collections.singletonList(byteBuffer), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testSingleWriteByteBufferZSTD() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        ByteBuffer sourcePayLoad = this.testHelper.generateBufferWithLongs(1024);
        this.testHelper.setCompressionStrategy(CompressionStrategy.ZSTD);
        this.runTestWithExceptionHandling(Collections.singletonList(sourcePayLoad), this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testSingleWriteByteBufferAlternateByteBufferProvider() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        List<ByteBuffer> bufferList = this.testHelper.generateRaggedPayloadBuffer(100, 1024, 10, 0, 0, 10);
        this.testHelper.setByteBufferProvider(() -> new ResourceHolder<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocate(131072);
            }

            public void close() {
            }
        });
        this.runTestWithExceptionHandling(bufferList, this.testCases.currentTestValue());
    }

    @Override
    @Test
    public void testRandomBlockAccess() throws Exception {
        Assume.assumeTrue((boolean)this.testCases.isCurrentTestEnabled());
        List<ByteBuffer> bufferList = this.testHelper.generateRaggedPayloadBuffer(8192, 32768, 256, 262144, 3, 1024);
        this.testHelper.setUseRandomReadOrder(true);
        this.runTestWithExceptionHandling(bufferList, this.testCases.currentTestValue());
    }

    private void runTestWithExceptionHandling(List<ByteBuffer> bufferList, TestCaseResult testCaseResult) throws Exception {
        try {
            this.testHelper.validateReadAndSize(bufferList, testCaseResult.size);
            if (testCaseResult.exception != null) {
                Assert.fail((String)("expected exception " + testCaseResult.exception.getClass().getName()));
            }
        }
        catch (Exception e) {
            if (testCaseResult.exception != null) {
                Assert.assertTrue((boolean)testCaseResult.exception.getClass().isAssignableFrom(e.getClass()));
            }
            throw e;
        }
    }
}

