/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ConstantDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.TestColumnSelector;
import org.apache.druid.segment.TestColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.TestVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.FallbackVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class FallbackVirtualColumnTest {
    @Test
    public void testGetOutputName() {
        Assert.assertEquals((Object)"slimshady", (Object)FallbackVirtualColumnTest.makeCol("slimshady", "test1", "test2").getOutputName());
    }

    @Test
    public void testGetColumns() {
        Assert.assertEquals(Arrays.asList(DefaultDimensionSpec.of((String)"test1"), DefaultDimensionSpec.of((String)"test2")), (Object)FallbackVirtualColumnTest.makeCol("slimshady", "test1", "test2").getColumns());
    }

    @Test
    public void testGetCacheKey() {
        Assert.assertArrayEquals((byte[])new CacheKeyBuilder(3).appendString("slimshady").appendCacheable((Cacheable)DefaultDimensionSpec.of((String)"test1")).appendCacheable((Cacheable)DefaultDimensionSpec.of((String)"test2")).appendCacheable((Cacheable)DefaultDimensionSpec.of((String)"oneMore")).build(), (byte[])FallbackVirtualColumnTest.makeCol("slimshady", "test1", "test2", "oneMore").getCacheKey());
    }

    @Test
    public void testMakeDimensionSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        ConstantDimensionSelector colA = new ConstantDimensionSelector("colA");
        ConstantDimensionSelector colB = new ConstantDimensionSelector("colB");
        ConstantDimensionSelector colC = new ConstantDimensionSelector("colC");
        TestColumnSelectorFactory selectorFactory = new TestColumnSelectorFactory().addDimSelector("colA", (DimensionSelector)colA).addDimSelector("colB", (DimensionSelector)colB).addDimSelector("colC", (DimensionSelector)colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (ColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testMakeColumnValueSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        ConstantDimensionSelector colA = new ConstantDimensionSelector("colA");
        ConstantDimensionSelector colB = new ConstantDimensionSelector("colB");
        ConstantDimensionSelector colC = new ConstantDimensionSelector("colC");
        TestColumnSelectorFactory selectorFactory = new TestColumnSelectorFactory().addColumnSelector("colA", colA).addColumnSelector("colB", colB).addColumnSelector("colC", colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeColumnValueSelector("abcd", (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeColumnValueSelector("abcd", (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeColumnValueSelector("abcd", (ColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeColumnValueSelector("abcd", (ColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testCanVectorize() {
        Assert.assertTrue((boolean)FallbackVirtualColumnTest.makeCol("slimshady", "test1").canVectorize(null));
    }

    @Test
    public void testMakeSingleValueVectorDimensionSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        SameVectorSelector colA = new SameVectorSelector();
        SameVectorSelector colB = new SameVectorSelector();
        SameVectorSelector colC = new SameVectorSelector();
        TestVectorColumnSelectorFactory selectorFactory = new TestVectorColumnSelectorFactory().addSVDVS("colA", colA).addSVDVS("colB", colB).addSVDVS("colC", colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeSingleValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeSingleValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeSingleValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeSingleValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testMakeMultiValueVectorDimensionSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        SameMultiVectorSelector colA = new SameMultiVectorSelector();
        SameMultiVectorSelector colB = new SameMultiVectorSelector();
        SameMultiVectorSelector colC = new SameMultiVectorSelector();
        TestVectorColumnSelectorFactory selectorFactory = new TestVectorColumnSelectorFactory().addMVDVS("colA", colA).addMVDVS("colB", colB).addMVDVS("colC", colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeMultiValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeMultiValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeMultiValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeMultiValueVectorDimensionSelector((DimensionSpec)new IgnoredDimensionSpec(), (VectorColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testMakeVectorValueSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        SameVectorSelector colA = new SameVectorSelector();
        SameVectorSelector colB = new SameVectorSelector();
        SameVectorSelector colC = new SameVectorSelector();
        TestVectorColumnSelectorFactory selectorFactory = new TestVectorColumnSelectorFactory().addVVS("colA", colA).addVVS("colB", colB).addVVS("colC", colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeVectorValueSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeVectorValueSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeVectorValueSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeVectorValueSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testMakeVectorObjectSelector() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        SameVectorSelector colA = new SameVectorSelector();
        SameVectorSelector colB = new SameVectorSelector();
        SameVectorSelector colC = new SameVectorSelector();
        TestVectorColumnSelectorFactory selectorFactory = new TestVectorColumnSelectorFactory().addVOS("colA", colA).addVOS("colB", colB).addVOS("colC", colC).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        Assert.assertSame((Object)colA, (Object)col.makeVectorObjectSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.makeVectorObjectSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.makeVectorObjectSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.makeVectorObjectSelector("abcd", (VectorColumnSelectorFactory)selectorFactory));
    }

    @Test
    public void testCapabilities() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        ColumnCapabilitiesImpl colA = ColumnCapabilitiesImpl.createDefault();
        ColumnCapabilitiesImpl colB = ColumnCapabilitiesImpl.createDefault();
        ColumnCapabilitiesImpl colC = ColumnCapabilitiesImpl.createDefault();
        TestVectorColumnSelectorFactory selectorFactory = new TestVectorColumnSelectorFactory().addCapabilities("colA", (ColumnCapabilities)colA).addCapabilities("colB", (ColumnCapabilities)colB).addCapabilities("colC", (ColumnCapabilities)colC);
        Assert.assertEquals((Object)ColumnCapabilitiesImpl.createDefault().getType(), (Object)col.capabilities("abcd").getType());
        Assert.assertSame((Object)colA, (Object)col.capabilities((ColumnInspector)selectorFactory, "abcd"));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.capabilities((ColumnInspector)selectorFactory, "abcd"));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.capabilities((ColumnInspector)selectorFactory, "abcd"));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertNull((Object)col.capabilities((ColumnInspector)selectorFactory, "abcd"));
    }

    @Test
    public void testRequiredColumns() {
        Assert.assertEquals(Arrays.asList("colA", "colB", "oneMore"), (Object)FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "oneMore").requiredColumns());
    }

    @Test
    public void testUsesDotNotation() {
        Assert.assertFalse((boolean)FallbackVirtualColumnTest.makeCol("hi", "my", "name", "is").usesDotNotation());
    }

    @Test
    public void testGetIndexSupplier() {
        FallbackVirtualColumn col = FallbackVirtualColumnTest.makeCol("slimshady", "colA", "colB", "colC");
        SameColumnIndexSupplier colA = new SameColumnIndexSupplier();
        SameColumnIndexSupplier colB = new SameColumnIndexSupplier();
        SameColumnIndexSupplier colC = new SameColumnIndexSupplier();
        TestColumnSelector selectorFactory = new TestColumnSelector().addHolder("colA", new HolderForIndexSupplier(colA)).addHolder("colB", new HolderForIndexSupplier(colB)).addHolder("colC", new HolderForIndexSupplier(colC)).addCapabilities("colA", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colB", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault()).addCapabilities("colC", (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault());
        ColumnSelectorColumnIndexSelector columnIndexSelector = new ColumnSelectorColumnIndexSelector((BitmapFactory)RoaringBitmapFactory.INSTANCE, VirtualColumns.EMPTY, (ColumnSelector)selectorFactory);
        Assert.assertSame((Object)colA, (Object)col.getIndexSupplier("abcd", (ColumnIndexSelector)columnIndexSelector));
        selectorFactory.addCapabilities("colA", null);
        Assert.assertSame((Object)colB, (Object)col.getIndexSupplier("abcd", (ColumnIndexSelector)columnIndexSelector));
        selectorFactory.addCapabilities("colB", null);
        Assert.assertSame((Object)colC, (Object)col.getIndexSupplier("abcd", (ColumnIndexSelector)columnIndexSelector));
        selectorFactory.addCapabilities("colC", null);
        Assert.assertSame((Object)colA, (Object)col.getIndexSupplier("abcd", (ColumnIndexSelector)columnIndexSelector));
    }

    private static FallbackVirtualColumn makeCol(String name, String ... cols) {
        return FallbackVirtualColumnTest.makeCol(name, (DimensionSpec[])Arrays.stream(cols).map(DefaultDimensionSpec::of).toArray(DimensionSpec[]::new));
    }

    private static FallbackVirtualColumn makeCol(String name, DimensionSpec ... specs) {
        return new FallbackVirtualColumn(name, new ArrayList<DimensionSpec>(Arrays.asList(specs)));
    }

    private static class HolderForIndexSupplier
    implements ColumnHolder {
        private final ColumnIndexSupplier indexSupplier;

        public HolderForIndexSupplier(ColumnIndexSupplier indexSupplier) {
            this.indexSupplier = indexSupplier;
        }

        public ColumnCapabilities getCapabilities() {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        public BaseColumn getColumn() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public ColumnIndexSupplier getIndexSupplier() {
            return this.indexSupplier;
        }

        public SettableColumnValueSelector<?> makeNewSettableColumnValueSelector() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SameMultiVectorSelector
    implements MultiValueDimensionVectorSelector {
        public int getValueCardinality() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String lookupName(int id) {
            throw new UnsupportedOperationException();
        }

        public boolean nameLookupPossibleInAdvance() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public IdLookup idLookup() {
            throw new UnsupportedOperationException();
        }

        public IndexedInts[] getRowVector() {
            throw new UnsupportedOperationException();
        }

        public int getMaxVectorSize() {
            throw new UnsupportedOperationException();
        }

        public int getCurrentVectorSize() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SameColumnIndexSupplier
    implements ColumnIndexSupplier {
        private SameColumnIndexSupplier() {
        }

        @Nullable
        public <T> T as(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SameVectorSelector
    implements SingleValueDimensionVectorSelector,
    VectorValueSelector,
    VectorObjectSelector {
        private SameVectorSelector() {
        }

        public int[] getRowVector() {
            throw new UnsupportedOperationException();
        }

        public int getValueCardinality() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String lookupName(int id) {
            throw new UnsupportedOperationException();
        }

        public boolean nameLookupPossibleInAdvance() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public IdLookup idLookup() {
            throw new UnsupportedOperationException();
        }

        public int getMaxVectorSize() {
            throw new UnsupportedOperationException();
        }

        public int getCurrentVectorSize() {
            throw new UnsupportedOperationException();
        }

        public long[] getLongVector() {
            throw new UnsupportedOperationException();
        }

        public float[] getFloatVector() {
            throw new UnsupportedOperationException();
        }

        public double[] getDoubleVector() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public boolean[] getNullVector() {
            throw new UnsupportedOperationException();
        }

        public Object[] getObjectVector() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IgnoredDimensionSpec
    implements DimensionSpec {
        private IgnoredDimensionSpec() {
        }

        public byte[] getCacheKey() {
            throw new UnsupportedOperationException();
        }

        public String getDimension() {
            throw new UnsupportedOperationException();
        }

        public String getOutputName() {
            throw new UnsupportedOperationException();
        }

        public ColumnType getOutputType() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public ExtractionFn getExtractionFn() {
            throw new UnsupportedOperationException();
        }

        public DimensionSelector decorate(DimensionSelector selector) {
            throw new UnsupportedOperationException();
        }

        public boolean mustDecorate() {
            throw new UnsupportedOperationException();
        }

        public boolean preservesOrdering() {
            throw new UnsupportedOperationException();
        }

        public DimensionSpec withDimension(String newDimension) {
            throw new UnsupportedOperationException();
        }
    }
}

