/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class NestedFieldVirtualColumnTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        NestedFieldVirtualColumn there = new NestedFieldVirtualColumn("nested", "$.x.y.z", "v0", ColumnType.LONG);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedFieldVirtualColumn andBackAgain = (NestedFieldVirtualColumn)JSON_MAPPER.readValue(json, NestedFieldVirtualColumn.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testSerdeArrayParts() throws JsonProcessingException {
        NestedFieldVirtualColumn there = new NestedFieldVirtualColumn("nested", "$.x.y.z[1]", "v0", ColumnType.LONG);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedFieldVirtualColumn andBackAgain = (NestedFieldVirtualColumn)JSON_MAPPER.readValue(json, NestedFieldVirtualColumn.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testBothPathAndPartsDefined() {
        Assert.assertThrows((String)"Cannot define both 'path' and 'pathParts'", IllegalArgumentException.class, () -> new NestedFieldVirtualColumn("nested", "v0", ColumnType.LONG, NestedPathFinder.parseJsonPath((String)"$.x.y.z"), Boolean.valueOf(false), "$.x.y.z", Boolean.valueOf(false)));
    }

    @Test
    public void testNoPathAndPartsDefined() {
        Assert.assertThrows((String)"Must define exactly one of 'path' or 'pathParts'", IllegalArgumentException.class, () -> new NestedFieldVirtualColumn("nested", "v0", ColumnType.LONG, null, null, null, null));
    }

    @Test
    public void testEquivalence() {
        NestedFieldVirtualColumn v1 = new NestedFieldVirtualColumn("nested", "$.x.y.z", "v0", ColumnType.LONG);
        NestedFieldVirtualColumn v2 = new NestedFieldVirtualColumn("nested", "$.x.y.z", "v1", ColumnType.LONG);
        NestedFieldVirtualColumn v3 = new NestedFieldVirtualColumn("nested", "$.x.y.z[0]", "v0", ColumnType.LONG);
        Assert.assertNotEquals((Object)v1, (Object)v2);
        Assert.assertEquals((Object)v1.getEquivalanceKey(), (Object)v2.getEquivalanceKey());
        Assert.assertNotEquals((Object)v1, (Object)v3);
        Assert.assertNotEquals((Object)v1.getEquivalanceKey(), (Object)v3.getEquivalanceKey());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(NestedFieldVirtualColumn.class).withNonnullFields(new String[]{"fieldSpec", "outputName"}).withIgnoredFields(new String[]{"hasNegativeArrayIndex"}).usingGetClass().verify();
    }
}

