/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmpFileSegmentWriteOutMediumTest {
    private volatile TmpFileSegmentWriteOutMedium writeOutMedium;
    private ExecutorService executorService;

    @Before
    public void setUp() throws IOException {
        this.writeOutMedium = new TmpFileSegmentWriteOutMedium(FileUtils.createTempDir());
        this.executorService = Execs.multiThreaded((int)3, (String)"writeOutMedium-%d");
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testFileCount() throws InterruptedException {
        int threadCount = 3;
        CountDownLatch latch = new CountDownLatch(3);
        for (int i = 0; i < 3; ++i) {
            this.executorService.submit(() -> {
                WriteOutBytes writeOutBytes = this.writeOutMedium.makeWriteOutBytes();
                Assert.assertEquals((long)0L, (long)this.writeOutMedium.getNumLocallyCreated());
                try {
                    latch.countDown();
                    latch.await();
                    ByteBuffer allocate = ByteBuffer.allocate(4096);
                    writeOutBytes.write(allocate);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((long)1L, (long)this.writeOutMedium.getNumLocallyCreated());
            });
        }
        this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)this.writeOutMedium.getFilesCreated());
    }
}

