/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.remote;

import com.google.common.base.Predicates;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.storage.remote.ChunkingStorageConnector;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;

public class TestStorageConnector
extends ChunkingStorageConnector<InputRange> {
    public static final String DATA = "This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text";
    public static final int CHUNK_SIZE_BYTES = 4;
    private final File tempDir;

    public TestStorageConnector(File tempDir) {
        super(4L);
        this.tempDir = tempDir;
    }

    public ChunkingStorageConnectorParameters<InputRange> buildInputParams(String path) {
        return this.buildInputParams(path, 0L, DATA.length());
    }

    public ChunkingStorageConnectorParameters<InputRange> buildInputParams(String path, long from, long size) {
        ChunkingStorageConnectorParameters.Builder builder = new ChunkingStorageConnectorParameters.Builder();
        builder.start(from);
        builder.end(from + size);
        builder.cloudStoragePath(path);
        builder.tempDirSupplier(() -> this.tempDir);
        builder.retryCondition(Predicates.alwaysFalse());
        builder.maxRetry(2);
        builder.objectSupplier((start, end) -> new InputRange((int)start, (int)end));
        builder.objectOpenFunction((ObjectOpenFunction)new ObjectOpenFunction<InputRange>(){

            public InputStream open(InputRange ir) {
                return IOUtils.toInputStream((String)TestStorageConnector.DATA.substring(ir.start, ir.end), (Charset)StandardCharsets.UTF_8);
            }

            public InputStream open(InputRange ir, long offset) {
                return this.open(new InputRange(ir.start + (int)offset, ir.end));
            }
        });
        return builder.build();
    }

    public boolean pathExists(String path) {
        throw new UnsupportedOperationException();
    }

    public OutputStream write(String path) {
        throw new UnsupportedOperationException();
    }

    public void deleteFile(String path) {
        throw new UnsupportedOperationException();
    }

    public void deleteFiles(Iterable<String> paths) {
        throw new UnsupportedOperationException();
    }

    public void deleteRecursively(String path) {
        throw new UnsupportedOperationException();
    }

    public Iterator<String> listDir(String dirName) {
        throw new UnsupportedOperationException();
    }

    public static class InputRange {
        private final int start;
        private final int end;

        public InputRange(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

