/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionRangeBucketShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SingleDimensionRangeBucketShardSpecTest {
    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new BuildingSingleDimensionShardSpec(1, "dim", "start", "end", 5), (Object)new SingleDimensionRangeBucketShardSpec(1, "dim", "start", "end").convert(5));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(1, 0, (Object)"test"), (Object)new SingleDimensionRangeBucketShardSpec(1, "dim", "start", "end").createChunk((Object)"test"));
    }

    @Test
    public void testShardSpecLookup() {
        ImmutableList shardSpecs = ImmutableList.of((Object)new SingleDimensionRangeBucketShardSpec(0, "dim", null, "c"), (Object)new SingleDimensionRangeBucketShardSpec(1, "dim", "f", "i"), (Object)new SingleDimensionRangeBucketShardSpec(2, "dim", "i", null));
        ShardSpecLookup lookup = ((ShardSpec)shardSpecs.get(0)).getLookup((List)shardSpecs);
        long currentTime = DateTimes.nowUtc().getMillis();
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"a", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"g", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"k", (Object)"time", (Object)currentTime))));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(SingleDimensionRangeBucketShardSpec.class, "bucket_single_dim")});
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)mapper));
        SingleDimensionRangeBucketShardSpec original = new SingleDimensionRangeBucketShardSpec(1, "dim", "start", "end");
        String json = mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"bucket_single_dim", (Object)shardSpec.getType());
        SingleDimensionRangeBucketShardSpec fromJson = (SingleDimensionRangeBucketShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SingleDimensionRangeBucketShardSpec.class).usingGetClass().suppress(new Warning[]{Warning.ALL_FIELDS_SHOULD_BE_USED}).verify();
    }
}

