/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class JvmUtilsTest {
    @Test
    public void testGetMaxDirectMemory() {
        long maxMemory = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
        Assert.assertTrue((maxMemory > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testSystemClassPath() {
        ClassLoader testClassLoader = this.getClass().getClassLoader();
        Assume.assumeTrue((boolean)(testClassLoader instanceof URLClassLoader));
        List parsedUrls = JvmUtils.systemClassPath();
        List<URL> classLoaderUrls = Arrays.asList(((URLClassLoader)testClassLoader).getURLs());
        Assert.assertEquals(classLoaderUrls, (Object)parsedUrls);
    }
}

