/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;

public class BlockingQueueOutputChannelFactory
implements OutputChannelFactory {
    private final int frameSize;

    public BlockingQueueOutputChannelFactory(int frameSize) {
        this.frameSize = frameSize;
    }

    @Override
    public OutputChannel openChannel(int partitionNumber) {
        BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
        return OutputChannel.immediatelyReadablePair(channel.writable(), ArenaMemoryAllocator.createOnHeap(this.frameSize), channel.readable(), partitionNumber);
    }

    @Override
    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
        throw new UnsupportedOperationException("Opening in-memory partitioned channels is not supported");
    }

    @Override
    public OutputChannel openNilChannel(int partitionNumber) {
        return OutputChannel.nil(partitionNumber);
    }
}

