/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="rows", value=Rows.class), @JsonSubTypes.Type(name="groups", value=Groups.class)})
@SubclassesMustOverrideEqualsAndHashCode
public interface WindowFrame {
    public static WindowFrame unbounded() {
        return WindowFrame.rows(null, null);
    }

    public static Rows rows(Integer lowerOffset, Integer upperOffset) {
        return new Rows(lowerOffset, upperOffset);
    }

    public static Groups groups(Integer lowerOffset, Integer upperOffset, List<String> orderByColumns) {
        return new Groups(lowerOffset, upperOffset, orderByColumns);
    }

    public static WindowFrame forOrderBy(String ... orderByColumns) {
        return WindowFrame.groups(null, 0, Lists.newArrayList((Object[])orderByColumns));
    }

    @Nullable
    default public <T extends WindowFrame> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public static class Groups
    extends OffsetFrame {
        @JsonProperty
        private final ImmutableList<String> orderByColumns;

        @JsonCreator
        public Groups(@JsonProperty(value="lowerOffset") Integer lowerOffset, @JsonProperty(value="upperOffset") Integer upperOffset, @JsonProperty(value="orderByColumns") List<String> orderByColumns) {
            super(lowerOffset, upperOffset);
            this.orderByColumns = ImmutableList.copyOf(orderByColumns);
        }

        public List<String> getOrderByColumns() {
            return this.orderByColumns;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.lowerOffset, this.orderByColumns, this.upperOffset);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Groups other = (Groups)obj;
            return Objects.equals(this.lowerOffset, other.lowerOffset) && Objects.equals(this.orderByColumns, other.orderByColumns) && Objects.equals(this.upperOffset, other.upperOffset);
        }

        @Override
        public String toString() {
            return "WindowFrame.Groups [lowerOffset=" + this.lowerOffset + ", upperOffset=" + this.upperOffset + ", orderByColumns=" + this.orderByColumns + "]";
        }
    }

    public static class Rows
    extends OffsetFrame {
        @JsonCreator
        public Rows(@JsonProperty(value="lowerOffset") Integer lowerOffset, @JsonProperty(value="upperOffset") Integer upperOffset) {
            super(lowerOffset, upperOffset);
        }

        @Override
        public String toString() {
            return "WindowFrame.Rows [lowerOffset=" + this.lowerOffset + ", upperOffset=" + this.upperOffset + "]";
        }
    }

    public static abstract class OffsetFrame
    implements WindowFrame {
        @JsonProperty
        public final Integer lowerOffset;
        @JsonProperty
        public final Integer upperOffset;

        @JsonCreator
        public OffsetFrame(@JsonProperty(value="lowerOffset") Integer lowerOffset, @JsonProperty(value="upperOffset") Integer upperOffset) {
            this.lowerOffset = lowerOffset;
            this.upperOffset = upperOffset;
        }

        public int hashCode() {
            return Objects.hash(this.lowerOffset, this.upperOffset);
        }

        public int getLowerOffsetClamped(int maxRows) {
            if (this.lowerOffset == null) {
                return -maxRows;
            }
            return Math.max(-maxRows, this.lowerOffset);
        }

        public int getUpperOffsetClamped(int maxRows) {
            if (this.upperOffset == null) {
                return maxRows;
            }
            return Math.min(maxRows, this.upperOffset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OffsetFrame other = (OffsetFrame)obj;
            return Objects.equals(this.lowerOffset, other.lowerOffset) && Objects.equals(this.upperOffset, other.upperOffset);
        }

        public abstract String toString();
    }
}

