/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.IOException;
import java.nio.IntBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class NumericDimensionMergerV9
implements DimensionMergerV9 {
    protected final String outputName;
    protected final IndexSpec indexSpec;
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final GenericColumnSerializer serializer;

    NumericDimensionMergerV9(String outputName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium) {
        this.outputName = outputName;
        this.indexSpec = indexSpec;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        try {
            this.serializer = this.setupEncodedValueWriter();
            this.serializer.open();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    abstract GenericColumnSerializer setupEncodedValueWriter();

    @Override
    public final void writeMergedValueDictionary(List<IndexableAdapter> adapters) {
    }

    @Override
    public final ColumnValueSelector convertSortedSegmentRowValuesToMergedRowValues(int segmentIndex, ColumnValueSelector source) {
        return source;
    }

    @Override
    public final void processMergedRow(ColumnValueSelector selector) throws IOException {
        this.serializer.serialize(selector);
    }

    @Override
    public final void writeIndexes(@Nullable List<IntBuffer> segmentRowNumConversions) {
    }

    @Override
    public boolean hasOnlyNulls() {
        return false;
    }
}

