/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.guava;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.CombiningSequence;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.ExplodingSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CombiningSequenceTest {
    private final int yieldEvery;

    @Parameterized.Parameters
    public static Collection<Object[]> valuesToTry() {
        return Arrays.asList({1}, {2}, {3}, {4}, {5}, {1000});
    }

    public CombiningSequenceTest(int yieldEvery) {
        this.yieldEvery = yieldEvery;
    }

    @Test
    public void testMerge() throws Exception {
        List<Pair<Integer, Integer>> pairs = Arrays.asList(Pair.of((Object)0, (Object)1), Pair.of((Object)0, (Object)2), Pair.of((Object)0, (Object)3), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)1), Pair.of((Object)5, (Object)10), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)1));
        List<Pair<Integer, Integer>> expected = Arrays.asList(Pair.of((Object)0, (Object)6), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)11), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)1));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testNoMergeOne() throws Exception {
        List<Pair<Integer, Integer>> pairs = Collections.singletonList(Pair.of((Object)0, (Object)1));
        List<Pair<Integer, Integer>> expected = Collections.singletonList(Pair.of((Object)0, (Object)1));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testMergeMany() throws Exception {
        List<Pair<Integer, Integer>> pairs = Arrays.asList(Pair.of((Object)0, (Object)6), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)11), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)1));
        List<Pair<Integer, Integer>> expected = Arrays.asList(Pair.of((Object)0, (Object)6), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)11), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)1));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testNoMergeTwo() throws Exception {
        List<Pair<Integer, Integer>> pairs = Arrays.asList(Pair.of((Object)0, (Object)1), Pair.of((Object)1, (Object)1));
        List<Pair<Integer, Integer>> expected = Arrays.asList(Pair.of((Object)0, (Object)1), Pair.of((Object)1, (Object)1));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testMergeTwo() throws Exception {
        List<Pair<Integer, Integer>> pairs = Arrays.asList(Pair.of((Object)0, (Object)1), Pair.of((Object)0, (Object)1));
        List<Pair<Integer, Integer>> expected = Collections.singletonList(Pair.of((Object)0, (Object)2));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testMergeSomeThingsMergedAtEnd() throws Exception {
        List<Pair<Integer, Integer>> pairs = Arrays.asList(Pair.of((Object)0, (Object)1), Pair.of((Object)0, (Object)2), Pair.of((Object)0, (Object)3), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)1), Pair.of((Object)5, (Object)10), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)1), Pair.of((Object)5, (Object)2), Pair.of((Object)5, (Object)2), Pair.of((Object)5, (Object)2), Pair.of((Object)5, (Object)2), Pair.of((Object)5, (Object)2));
        List<Pair<Integer, Integer>> expected = Arrays.asList(Pair.of((Object)0, (Object)6), Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)1), Pair.of((Object)5, (Object)11), Pair.of((Object)6, (Object)1), Pair.of((Object)5, (Object)11));
        this.testCombining(pairs, expected);
    }

    @Test
    public void testNothing() throws Exception {
        this.testCombining(Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testExplodingSequence() {
        ExplodingSequence bomb = new ExplodingSequence(Sequences.simple((Iterable)ImmutableList.of((Object)1, (Object)2, (Object)2)), false, true);
        CombiningSequence combiningSequence = CombiningSequence.create((Sequence)bomb, Comparator.naturalOrder(), (a, b) -> a);
        try {
            combiningSequence.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

                public Integer accumulate(Integer accumulated, Integer in) {
                    if (in > 1) {
                        throw new RuntimeException("boom");
                    }
                    return in;
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"boom")));
        }
        Assert.assertEquals((String)"Closes resources", (long)1L, (long)bomb.getCloseCount());
    }

    private void testCombining(List<Pair<Integer, Integer>> pairs, List<Pair<Integer, Integer>> expected) throws Exception {
        for (int limit = 0; limit < expected.size() + 1; ++limit) {
            int expectedLimit = limit == 0 ? 1 : limit;
            this.testCombining(pairs, Lists.newArrayList((Iterable)Iterables.limit(expected, (int)expectedLimit)), limit);
        }
    }

    private void testCombining(List<Pair<Integer, Integer>> pairs, List<Pair<Integer, Integer>> expected, int limit) throws Exception {
        String prefix = StringUtils.format((String)"yieldEvery[%d], limit[%d]", (Object[])new Object[]{this.yieldEvery, limit});
        CountDownLatch closed = new CountDownLatch(1);
        Closeable closeable = closed::countDown;
        Sequence seq = CombiningSequence.create((Sequence)Sequences.simple(pairs).withBaggage(closeable), (Comparator)Ordering.natural().onResultOf(p -> (Comparable)p.lhs), (lhs, rhs) -> {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            return Pair.of((Object)((Integer)lhs.lhs), (Object)((Integer)lhs.rhs + (Integer)rhs.rhs));
        }).limit((long)limit);
        List merged = seq.toList();
        Assert.assertEquals((String)prefix, expected, (Object)merged);
        Yielder yielder = seq.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Pair<Integer, Integer>, Pair<Integer, Integer>>(){
            int count = 0;

            public Pair<Integer, Integer> accumulate(Pair<Integer, Integer> lhs, Pair<Integer, Integer> rhs) {
                ++this.count;
                if (this.count % CombiningSequenceTest.this.yieldEvery == 0) {
                    this.yield();
                }
                return rhs;
            }
        });
        UnmodifiableIterator expectedVals = Iterators.filter(expected.iterator(), (Predicate)new Predicate<Pair<Integer, Integer>>(){
            int count = 0;

            public boolean apply(@Nullable Pair<Integer, Integer> input) {
                ++this.count;
                return this.count % CombiningSequenceTest.this.yieldEvery == 0;
            }
        });
        int i = 0;
        if (expectedVals.hasNext()) {
            while (!yielder.isDone()) {
                Pair expectedVal = (Pair)expectedVals.next();
                Pair actual = (Pair)yielder.get();
                Assert.assertEquals((String)StringUtils.format((String)"%s, i[%s]", (Object[])new Object[]{prefix, i++}), (Object)expectedVal, (Object)actual);
                yielder = yielder.next((Object)actual);
            }
        }
        Assert.assertTrue((String)prefix, (boolean)yielder.isDone());
        Assert.assertFalse((String)prefix, (boolean)expectedVals.hasNext());
        yielder.close();
        Assert.assertTrue((String)"resource closed", (boolean)closed.await(10000L, TimeUnit.MILLISECONDS));
    }
}

