/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.semantic;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.CloseableShapeshifter;
import org.junit.Assert;
import org.junit.Test;

public class SemanticUtilsTest {
    @Test
    public void testInvalidParameters() {
        Assert.assertThrows(DruidException.class, () -> SemanticUtils.makeAsMap(InvalidShapeshifter.class));
    }

    @Test
    public void testValidParameters() {
        TestShapeshifter testShapeshifter = new TestShapeshifter();
        Assert.assertTrue((boolean)(testShapeshifter.as(A.class) instanceof A));
    }

    @Test
    public void testOverrideForNewMapping() {
        SemanticUtils.registerAsOverride(TestShapeshifter.class, OverrideClass.class, testShapeshifter -> new OverrideClass());
        TestShapeshifter testShapeshifter2 = new TestShapeshifter();
        Assert.assertTrue((boolean)(testShapeshifter2.as(A.class) instanceof A));
        Assert.assertTrue((boolean)(testShapeshifter2.as(OverrideClass.class) instanceof OverrideClass));
    }

    @Test
    public void testOverrideForExistingMapping() {
        SemanticUtils.registerAsOverride(TestShapeshifter.class, A.class, testShapeshifter -> new OverrideClass());
        TestShapeshifter testShapeshifter2 = new TestShapeshifter();
        Assert.assertTrue((boolean)(testShapeshifter2.as(A.class) instanceof OverrideClass));
    }

    static class OverrideClass
    extends A {
        OverrideClass() {
        }
    }

    static class A
    implements AInterface {
        A() {
        }
    }

    static interface AInterface {
    }

    static class InvalidShapeshifter
    implements CloseableShapeshifter {
        InvalidShapeshifter() {
        }

        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            return null;
        }

        public void close() {
        }

        @SemanticCreator
        public AInterface toAInterface(String invalidParameter) {
            return new A();
        }
    }

    static class TestShapeshifter
    implements CloseableShapeshifter {
        private final Map<Class<?>, Function<TestShapeshifter, ?>> asMap = SemanticUtils.makeAsMap(TestShapeshifter.class);

        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            return (T)this.asMap.getOrDefault(clazz, arg -> null).apply(this);
        }

        public void close() {
        }

        @SemanticCreator
        public AInterface toAInterface() {
            return new A();
        }
    }
}

