/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.utils.CompressionUtils;

public class ResourceInputSource
extends AbstractInputSource {
    private final ClassLoader classLoader;
    private final String resourceFile;

    public static ResourceInputSource of(ClassLoader loader, String resourceFile) {
        return new ResourceInputSource(loader, resourceFile);
    }

    private ResourceInputSource(ClassLoader classLoader, String resourceFile) {
        this.classLoader = classLoader;
        this.resourceFile = resourceFile;
    }

    public boolean isSplittable() {
        return false;
    }

    public boolean needsFormat() {
        return true;
    }

    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage(Collections.singletonList(new ResourceStreamEntity(this.classLoader, this.resourceFile)).iterator()), SystemFieldDecoratorFactory.NONE, temporaryDirectory);
    }

    public static class ResourceStreamEntity
    implements InputEntity {
        private final ClassLoader classLoader;
        private final String resourceFile;

        public ResourceStreamEntity(ClassLoader classLoader, String resourceFile) {
            this.classLoader = classLoader;
            this.resourceFile = resourceFile;
        }

        @Nullable
        public URI getUri() {
            try {
                return this.classLoader.getResource(this.resourceFile).toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public InputStream open() throws IOException {
            InputStream resourceStream = this.classLoader.getResourceAsStream(this.resourceFile);
            return CompressionUtils.decompress((InputStream)resourceStream, (String)this.resourceFile);
        }
    }
}

