/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class DelimitedReaderTest {
    private static final InputRowSchema INPUT_ROW_SCHEMA = new InputRowSchema(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "name"))), ColumnsFilter.all());

    @Test
    public void testWithoutHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z\tname_1\t5\t0.0", (Object)"2019-01-01T00:00:20Z\tname_2\t10\t1.0", (Object)"2019-01-01T00:00:30Z\tname_3\t15\t2.0"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score", (Object)"rating_dbl"), null, null, null, Boolean.valueOf(false), 0, null);
        this.assertResult(source, format);
    }

    @Test
    public void testParseNumbers() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z\tname_1\t5\t0.0", (Object)"2019-01-01T00:00:20Z\tname_2\t10\t1.0", (Object)"2019-01-01T00:00:30Z\tname_3\t15\t2.0"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score", (Object)"rating_dbl"), null, null, null, Boolean.valueOf(false), 0, Boolean.valueOf(true));
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumn() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), null, null, null, Boolean.valueOf(true), 0, null);
        this.assertResult(source, format);
    }

    @Test
    public void testSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this\tis\ta\trow\tto\tskip", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score"), null, null, null, Boolean.valueOf(false), 1, null);
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumnAndSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this\tis\ta\trow\tto\tskip", (Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), null, null, null, Boolean.valueOf(true), 1, null);
        this.assertResult(source, format);
    }

    @Test
    public void testMultiValues() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5|1", (Object)"2019-01-01T00:00:20Z\tname_2\t10|2", (Object)"2019-01-01T00:00:30Z\tname_3\t15|3"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), "|", null, null, Boolean.valueOf(true), 0, null);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)ImmutableList.of((Object)Integer.toString((numResults + 1) * 5), (Object)Integer.toString(numResults + 1)), (Object)row.getDimension("score"));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }

    @Test
    public void testDataWithParseNumbersEnabled() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"3\t1.0\t2\t1|2|3\tfalse\t2018-05-05T10:00:00Z", (Object)"34\t-2.0\tfoo\t1\ttrue\t2018-05-06T10:00:00Z", (Object)"343\t3.0\tbar\t2|3|4\tfalse\t2018-05-07T10:00:00Z", (Object)"545\t-4.0\t7\t2\ttrue\t2018-05-08T10:00:00Z", (Object)"65\t5.0\tbaz\t3|4\tfalse\t2018-05-09T10:00:00Z"));
        RowSignature signature = RowSignature.builder().add("Value1", null).add("Value2", null).add("Value3", null).add("Value4", null).add("Value5", null).add("Timestamp", null).build();
        ImmutableList expectedResults = ImmutableList.of((Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-05T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)3L, (Object)1.0, (Object)2L, (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)"false", (Object)"2018-05-05T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-06T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)34L, (Object)-2.0, (Object)"foo", (Object)1L, (Object)"true", (Object)"2018-05-06T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-07T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)343L, (Object)3.0, (Object)"bar", (Object)ImmutableList.of((Object)2L, (Object)3L, (Object)4L), (Object)"false", (Object)"2018-05-07T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-08T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)545L, (Object)-4.0, (Object)7L, (Object)2L, (Object)"true", (Object)"2018-05-08T10:00:00Z")), (Object)new ListBasedInputRow(signature, DateTimes.of((String)"2018-05-09T10:00:00Z"), (List)ImmutableList.of((Object)"Timestamp"), (List)ImmutableList.of((Object)65L, (Object)5.0, (Object)"baz", (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)"false", (Object)"2018-05-09T10:00:00Z")));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"Value1", (Object)"Value2", (Object)"Value3", (Object)"Value4", (Object)"Value5", (Object)"Timestamp"), "|", null, Boolean.valueOf(false), null, 0, Boolean.valueOf(true));
        InputEntityReader reader = format.createReader(new InputRowSchema(new TimestampSpec("Timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"Timestamp"))), ColumnsFilter.all()), (InputEntity)source, null);
        try (CloseableIterator iterator = reader.read();){
            Iterator expectedRowIterator = expectedResults.iterator();
            while (iterator.hasNext()) {
                Assert.assertTrue((boolean)expectedRowIterator.hasNext());
                Assert.assertEquals(expectedRowIterator.next(), (Object)iterator.next());
            }
        }
    }

    @Test
    public void testCustomizeSeparator() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts|name|score", (Object)"2019-01-01T00:00:10Z|name_1|5\t1", (Object)"2019-01-01T00:00:20Z|name_2|10\t2", (Object)"2019-01-01T00:00:30Z|name_3|15\t3"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), "\t", "|", null, Boolean.valueOf(true), 0, null);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)ImmutableList.of((Object)Integer.toString((numResults + 1) * 5), (Object)Integer.toString(numResults + 1)), (Object)row.getDimension("score"));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }

    @Test
    public void testRussianTextMess() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z\tname_1\t\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442 \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"Comment"), null, null, null, Boolean.valueOf(false), 0, null);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        try (CloseableIterator iterator = reader.read();){
            Assert.assertTrue((boolean)iterator.hasNext());
            InputRow row = (InputRow)iterator.next();
            Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01T00:00:10Z"), (Object)row.getTimestamp());
            Assert.assertEquals((Object)"name_1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
            Assert.assertEquals((Object)"\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442 \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("Comment")));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private ByteEntity writeData(List<String> lines) throws IOException {
        List byteLines = lines.stream().map(line -> StringUtils.toUtf8((String)(line + "\n"))).collect(Collectors.toList());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(byteLines.stream().mapToInt(bytes -> ((byte[])bytes).length).sum());
        for (byte[] bytes2 : byteLines) {
            outputStream.write(bytes2);
        }
        return new ByteEntity(outputStream.toByteArray());
    }

    private void assertResult(ByteEntity source, DelimitedInputFormat format) throws IOException {
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                if (format.shouldTryParseNumbers()) {
                    Assert.assertEquals((Object)((long)(numResults + 1) * 5L), (Object)row.getRaw("score"));
                    if (format.getColumns().contains("rating_dbl")) {
                        Assert.assertEquals((Object)((double)numResults * 1.0), (Object)row.getRaw("rating_dbl"));
                    }
                } else {
                    Assert.assertEquals((Object)Integer.toString((numResults + 1) * 5), (Object)row.getRaw("score"));
                    if (format.getColumns().contains("rating_dbl")) {
                        Assert.assertEquals((Object)Double.toString((double)numResults * 1.0), (Object)row.getRaw("rating_dbl"));
                    }
                }
                Assert.assertEquals((Object)Integer.toString((numResults + 1) * 5), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }
}

