/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import java.util.Optional;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMemoryAllocatorTest {
    private static final int ALLOCATOR_SIZE = 10;

    protected abstract MemoryAllocator makeAllocator(int var1);

    @Test
    public void testAllocationInSinglePass() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        Optional memoryResourceHolderOptional = memoryAllocator.allocate(10L);
        Assert.assertTrue((boolean)memoryResourceHolderOptional.isPresent());
        ResourceHolder memoryResourceHolder = (ResourceHolder)memoryResourceHolderOptional.get();
        WritableMemory memory = (WritableMemory)memoryResourceHolder.get();
        for (int i = 0; i < 10; ++i) {
            memory.putByte((long)i, (byte)-1);
        }
    }

    @Test
    public void testAllocationInMultiplePasses() {
        int i;
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        Optional memoryResourceHolderOptional1 = memoryAllocator.allocate(6L);
        Assert.assertTrue((boolean)memoryResourceHolderOptional1.isPresent());
        ResourceHolder memoryResourceHolder1 = (ResourceHolder)memoryResourceHolderOptional1.get();
        WritableMemory memory1 = (WritableMemory)memoryResourceHolder1.get();
        Optional memoryResourceHolderOptional2 = memoryAllocator.allocate(4L);
        Assert.assertTrue((boolean)memoryResourceHolderOptional2.isPresent());
        ResourceHolder memoryResourceHolder2 = (ResourceHolder)memoryResourceHolderOptional2.get();
        WritableMemory memory2 = (WritableMemory)memoryResourceHolder2.get();
        for (i = 0; i < 6; ++i) {
            memory1.putByte((long)i, (byte)-1);
        }
        for (i = 0; i < 4; ++i) {
            memory2.putByte((long)i, (byte)-2);
        }
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)-1L, (long)memory1.getByte((long)i));
        }
        for (i = 0; i < 4; ++i) {
            Assert.assertEquals((long)-2L, (long)memory2.getByte((long)i));
        }
    }

    @Test
    public void testReleaseAllocationTwice() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        int allocationSize = 4;
        Optional holder1 = memoryAllocator.allocate(4L);
        Optional holder2 = memoryAllocator.allocate(4L);
        Assert.assertTrue((boolean)holder1.isPresent());
        Assert.assertTrue((boolean)holder2.isPresent());
        Assert.assertEquals((long)2L, (long)memoryAllocator.available());
        ((ResourceHolder)holder2.get()).close();
        Assert.assertEquals((long)6L, (long)memoryAllocator.available());
        ((ResourceHolder)holder2.get()).close();
        Assert.assertEquals((long)6L, (long)memoryAllocator.available());
        ((ResourceHolder)holder1.get()).close();
        Assert.assertEquals((long)10L, (long)memoryAllocator.available());
    }

    @Test
    public void testReleaseLastAllocationFirst() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        int allocationSize = 4;
        Optional holder1 = memoryAllocator.allocate(4L);
        Optional holder2 = memoryAllocator.allocate(4L);
        Assert.assertTrue((boolean)holder1.isPresent());
        Assert.assertTrue((boolean)holder2.isPresent());
        Assert.assertEquals((long)2L, (long)memoryAllocator.available());
        ((ResourceHolder)holder2.get()).close();
        Assert.assertEquals((long)6L, (long)memoryAllocator.available());
        ((ResourceHolder)holder1.get()).close();
        Assert.assertEquals((long)10L, (long)memoryAllocator.available());
    }

    @Test
    public void testReleaseLastAllocationLast() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        int allocationSize = 4;
        Optional holder1 = memoryAllocator.allocate(4L);
        Optional holder2 = memoryAllocator.allocate(4L);
        Assert.assertTrue((boolean)holder1.isPresent());
        Assert.assertTrue((boolean)holder2.isPresent());
        Assert.assertEquals((long)2L, (long)memoryAllocator.available());
        ((ResourceHolder)holder1.get()).close();
        ((ResourceHolder)holder2.get()).close();
        Assert.assertEquals((long)10L, (long)memoryAllocator.available());
    }

    @Test
    public void testOverallocationInSinglePass() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        Optional memoryResourceHolderOptional = memoryAllocator.allocate(11L);
        Assert.assertFalse((boolean)memoryResourceHolderOptional.isPresent());
    }

    @Test
    public void testOverallocationInMultiplePasses() {
        MemoryAllocator memoryAllocator = this.makeAllocator(10);
        Optional memoryResourceHolderOptional = memoryAllocator.allocate(6L);
        Assert.assertTrue((boolean)memoryResourceHolderOptional.isPresent());
        Assert.assertFalse((boolean)memoryAllocator.allocate(5L).isPresent());
    }
}

