/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.frame.processor.TournamentTree;
import org.junit.Assert;
import org.junit.Test;

public class TournamentTreeTest {
    @Test
    public void test_construction_oneElement() {
        IntComparator intComparator = IntComparators.NATURAL_COMPARATOR;
        TournamentTree tree = new TournamentTree(1, intComparator);
        Assert.assertEquals((long)0L, (long)tree.getMin());
        Assert.assertArrayEquals((String)"construction", (int[])new int[]{0}, (int[])tree.backingArray());
    }

    @Test
    public void test_construction_tenElements_natural() {
        IntComparator intComparator = IntComparators.NATURAL_COMPARATOR;
        TournamentTree tree = new TournamentTree(10, intComparator);
        Assert.assertEquals((long)0L, (long)tree.getMin());
        Assert.assertArrayEquals((String)"construction", (int[])new int[]{0, 8, 4, 12, 2, 6, 10, 14, 1, 3, 5, 7, 9, 11, 13, 15}, (int[])tree.backingArray());
    }

    @Test
    public void test_construction_tenElements_reverse() {
        IntComparator intComparator = IntComparators.OPPOSITE_COMPARATOR;
        TournamentTree tree = new TournamentTree(10, intComparator);
        Assert.assertEquals((long)9L, (long)tree.getMin());
        Assert.assertArrayEquals((String)"construction", (int[])new int[]{9, 7, 3, 12, 1, 5, 10, 14, 0, 2, 4, 6, 8, 11, 13, 15}, (int[])tree.backingArray());
    }

    @Test
    public void test_construction_sixteenElements_reverse() {
        IntComparator intComparator = IntComparators.OPPOSITE_COMPARATOR;
        TournamentTree tree = new TournamentTree(16, intComparator);
        Assert.assertEquals((long)15L, (long)tree.getMin());
        Assert.assertArrayEquals((String)"construction", (int[])new int[]{15, 7, 3, 11, 1, 5, 9, 13, 0, 2, 4, 6, 8, 10, 12, 14}, (int[])tree.backingArray());
    }

    @Test
    public void test_merge_eightLists() {
        ImmutableList lists = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)1, (Object)5), (Object)ImmutableList.of((Object)0, (Object)4), (Object)ImmutableList.of((Object)1, (Object)5, (Object)5, (Object)6, (Object)9), (Object)ImmutableList.of((Object)1, (Object)6, (Object)7, (Object)8), (Object)ImmutableList.of((Object)2, (Object)2, (Object)3, (Object)5, (Object)7), (Object)ImmutableList.of((Object)0, (Object)2, (Object)4, (Object)8, (Object)9), (Object)ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)6, (Object)7, (Object)7), (Object)ImmutableList.of((Object)1, (Object)3, (Object)6, (Object)7, (Object)7));
        ArrayList queues = new ArrayList();
        for (List list : lists) {
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queues.add(queue);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                queue.addLast(i);
            }
        }
        IntComparator intComparator = (a, b) -> {
            Integer itemA = (Integer)((Deque)queues.get(a)).peek();
            Integer itemB = (Integer)((Deque)queues.get(b)).peek();
            return Ordering.natural().nullsLast().compare((Object)itemA, (Object)itemB);
        };
        TournamentTree tree = new TournamentTree(lists.size(), intComparator);
        ArrayList<Integer> intsRead = new ArrayList<Integer>();
        while (((Deque)queues.get(tree.getMin())).peek() != null) {
            intsRead.add((Integer)((Deque)queues.get(tree.getMin())).poll());
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.addAll(Arrays.asList(0, 0, 0));
        expected.addAll(Arrays.asList(1, 1, 1, 1, 1, 1));
        expected.addAll(Arrays.asList(2, 2, 2, 2));
        expected.addAll(Arrays.asList(3, 3));
        expected.addAll(Arrays.asList(4, 4, 4));
        expected.addAll(Arrays.asList(5, 5, 5, 5));
        expected.addAll(Arrays.asList(6, 6, 6, 6));
        expected.addAll(Arrays.asList(7, 7, 7, 7, 7, 7));
        expected.addAll(Arrays.asList(8, 8));
        expected.addAll(Arrays.asList(9, 9));
        Assert.assertEquals(expected, intsRead);
    }

    @Test
    public void test_merge_tenLists() {
        ImmutableList lists = ImmutableList.of((Object)ImmutableList.of((Object)0, (Object)1, (Object)1, (Object)5), (Object)ImmutableList.of((Object)0, (Object)4), (Object)ImmutableList.of((Object)1, (Object)5, (Object)5, (Object)6, (Object)9), (Object)ImmutableList.of((Object)1, (Object)6, (Object)7, (Object)8), (Object)ImmutableList.of((Object)2, (Object)2, (Object)3, (Object)5, (Object)7), (Object)ImmutableList.of((Object)0, (Object)2, (Object)4, (Object)8, (Object)9), (Object)ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)6, (Object)7, (Object)7), (Object)ImmutableList.of((Object)1, (Object)3, (Object)6, (Object)7, (Object)7), (Object)ImmutableList.of((Object)1, (Object)3, (Object)3, (Object)4, (Object)5, (Object)6), (Object)ImmutableList.of((Object)4, (Object)4, (Object)6, (Object)7));
        ArrayList queues = new ArrayList();
        for (List list : lists) {
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queues.add(queue);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                queue.addLast(i);
            }
        }
        IntComparator intComparator = (a, b) -> {
            Integer itemA = (Integer)((Deque)queues.get(a)).peek();
            Integer itemB = (Integer)((Deque)queues.get(b)).peek();
            return Ordering.natural().nullsLast().compare((Object)itemA, (Object)itemB);
        };
        TournamentTree tree = new TournamentTree(lists.size(), intComparator);
        ArrayList<Integer> intsRead = new ArrayList<Integer>();
        while (((Deque)queues.get(tree.getMin())).peek() != null) {
            intsRead.add((Integer)((Deque)queues.get(tree.getMin())).poll());
        }
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.addAll(Arrays.asList(0, 0, 0));
        expected.addAll(Arrays.asList(1, 1, 1, 1, 1, 1, 1));
        expected.addAll(Arrays.asList(2, 2, 2, 2));
        expected.addAll(Arrays.asList(3, 3, 3, 3));
        expected.addAll(Arrays.asList(4, 4, 4, 4, 4, 4));
        expected.addAll(Arrays.asList(5, 5, 5, 5, 5));
        expected.addAll(Arrays.asList(6, 6, 6, 6, 6, 6));
        expected.addAll(Arrays.asList(7, 7, 7, 7, 7, 7, 7));
        expected.addAll(Arrays.asList(8, 8));
        expected.addAll(Arrays.asList(9, 9));
        Assert.assertEquals(expected, intsRead);
    }
}

