/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;

public abstract class SingleChannelFrameProcessor<T>
implements FrameProcessor<T> {
    @Nullable
    private final ReadableFrameChannel readableFrameChannel;
    @Nullable
    private final WritableFrameChannel writableFrameChannel;

    public SingleChannelFrameProcessor(@Nullable ReadableFrameChannel readableFrameChannel, @Nullable WritableFrameChannel writableFrameChannel) {
        this.readableFrameChannel = readableFrameChannel;
        this.writableFrameChannel = writableFrameChannel;
    }

    public List<ReadableFrameChannel> inputChannels() {
        if (this.readableFrameChannel == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.readableFrameChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        if (this.writableFrameChannel == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.writableFrameChannel);
    }

    public ReturnOrAwait<T> runIncrementally(IntSet readableInputs) throws IOException {
        return ReturnOrAwait.returnObject(this.doSimpleWork());
    }

    public abstract T doSimpleWork() throws IOException;

    public void cleanup() {
    }
}

