/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.nio.ByteBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.junit.Assert;
import org.junit.Test;

public class FrameWriterUtilsTest {
    private static final byte[] INPUT_BYTE_ARRAY = new byte[]{10, -92, 0, 83};
    private static final ByteBuffer INPUT_BYTE_BUFFER = ByteBuffer.wrap(INPUT_BYTE_ARRAY);
    private static final WritableMemory WRITABLE_MEMORY = WritableMemory.allocate((int)10);

    @Test
    public void test_copyByteBufferToMemory_withAllowNullBytesOnArrayBackedBuffer() {
        int originalPosition = INPUT_BYTE_BUFFER.position();
        FrameWriterUtils.copyByteBufferToMemoryAllowingNullBytes((ByteBuffer)INPUT_BYTE_BUFFER, (WritableMemory)WRITABLE_MEMORY, (long)0L, (int)4);
        byte[] outputArray = new byte[4];
        WRITABLE_MEMORY.getByteArray(0L, outputArray, 0, 4);
        Assert.assertArrayEquals((byte[])INPUT_BYTE_ARRAY, (byte[])outputArray);
        Assert.assertEquals((long)originalPosition, (long)INPUT_BYTE_BUFFER.position());
    }

    @Test
    public void test_copyByteBufferToMemory_withAllowNullBytes() {
        int originalPosition = INPUT_BYTE_BUFFER.position();
        ByteBuffer inputBuffer = ByteBuffer.allocateDirect(10);
        inputBuffer.put(INPUT_BYTE_ARRAY, 0, 4);
        inputBuffer.rewind();
        FrameWriterUtils.copyByteBufferToMemoryAllowingNullBytes((ByteBuffer)inputBuffer, (WritableMemory)WRITABLE_MEMORY, (long)0L, (int)4);
        byte[] outputArray = new byte[4];
        WRITABLE_MEMORY.getByteArray(0L, outputArray, 0, 4);
        Assert.assertArrayEquals((byte[])INPUT_BYTE_ARRAY, (byte[])outputArray);
        Assert.assertEquals((long)originalPosition, (long)INPUT_BYTE_BUFFER.position());
    }

    @Test
    public void test_copyByteBufferToMemory_withRemoveNullBytes() {
        int originalPosition = INPUT_BYTE_BUFFER.position();
        FrameWriterUtils.copyByteBufferToMemoryDisallowingNullBytes((ByteBuffer)INPUT_BYTE_BUFFER, (WritableMemory)WRITABLE_MEMORY, (long)0L, (int)4, (boolean)true);
        byte[] outputArray = new byte[3];
        WRITABLE_MEMORY.getByteArray(0L, outputArray, 0, 3);
        Assert.assertArrayEquals((byte[])new byte[]{10, -92, 83}, (byte[])outputArray);
        Assert.assertEquals((long)originalPosition, (long)INPUT_BYTE_BUFFER.position());
    }

    @Test
    public void test_copyByteBufferToMemory_withDisallowedNullBytes() {
        Assert.assertThrows(InvalidNullByteException.class, () -> FrameWriterUtils.copyByteBufferToMemoryDisallowingNullBytes((ByteBuffer)INPUT_BYTE_BUFFER, (WritableMemory)WRITABLE_MEMORY, (long)0L, (int)4, (boolean)false));
    }
}

