/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.druid.guice.DruidExtensionDependencies;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.StandardURLClassLoader;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExtensionsLoaderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, byte[]> jarFileContents = ImmutableMap.of((Object)"jar-resource", (Object)"jar-resource-contents".getBytes(Charset.defaultCharset()));

    private Injector startupInjector() {
        return new StartupInjectorBuilder().withEmptyProperties().withExtensions().build();
    }

    @Test
    public void test02MakeStartupInjector() {
        Injector startupInjector = this.startupInjector();
        Assert.assertNotNull((Object)startupInjector);
        Assert.assertNotNull((Object)startupInjector.getInstance(ObjectMapper.class));
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Assert.assertNotNull((Object)extnLoader);
        Assert.assertSame((Object)extnLoader, (Object)ExtensionsLoader.instance((Injector)startupInjector));
    }

    @Test
    public void test04DuplicateClassLoaderExtensions() throws Exception {
        File extensionDir = this.temporaryFolder.newFolder();
        Injector startupInjector = this.startupInjector();
        ExtensionsLoader extnLoader = ExtensionsLoader.instance((Injector)startupInjector);
        Pair key = Pair.of((Object)extensionDir, (Object)true);
        extnLoader.getLoadersMap().put(key, new StandardURLClassLoader(new URL[0], ExtensionsLoader.class.getClassLoader(), (List)ImmutableList.of()));
        Collection modules = extnLoader.getFromExtensions(DruidModule.class);
        HashSet<String> loadedModuleNames = new HashSet<String>();
        for (DruidModule module : modules) {
            Assert.assertFalse((String)"Duplicate extensions are loaded", (boolean)loadedModuleNames.contains(module.getClass().getName()));
            loadedModuleNames.add(module.getClass().getName());
        }
    }

    @Test
    public void test06GetClassLoaderForExtension() throws IOException {
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(), this.objectMapper);
        File some_extension_dir = this.temporaryFolder.newFolder();
        File a_jar = new File(some_extension_dir, "a.jar");
        File b_jar = new File(some_extension_dir, "b.jar");
        File c_jar = new File(some_extension_dir, "c.jar");
        this.createNewJar(a_jar, this.jarFileContents);
        this.createNewJar(b_jar, this.jarFileContents);
        this.createNewJar(c_jar, this.jarFileContents);
        StandardURLClassLoader loader = extnLoader.getClassLoaderForExtension(some_extension_dir, false);
        Object[] expectedURLs = new URL[]{a_jar.toURI().toURL(), b_jar.toURI().toURL(), c_jar.toURI().toURL()};
        Object[] actualURLs = loader.getURLs();
        Arrays.sort(actualURLs, Comparator.comparing(URL::getPath));
        Assert.assertArrayEquals((Object[])expectedURLs, (Object[])actualURLs);
    }

    @Test
    public void testGetLoadedModules() {
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(), this.objectMapper);
        Collection modules = extnLoader.getModules();
        HashSet moduleSet = new HashSet(modules);
        Collection loadedModules = extnLoader.getModules();
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", (long)modules.size(), (long)loadedModules.size());
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", moduleSet, new HashSet(loadedModules));
        Collection loadedModules2 = extnLoader.getModules();
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", (long)modules.size(), (long)loadedModules2.size());
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", moduleSet, new HashSet(loadedModules2));
    }

    @Test
    public void testGetExtensionFilesToLoad_non_exist_extensions_dir() throws IOException {
        final File tmpDir = this.temporaryFolder.newFolder();
        Assert.assertTrue((String)"could not create missing folder", (!tmpDir.exists() || tmpDir.delete() ? 1 : 0) != 0);
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(){

            public String getDirectory() {
                return tmpDir.getAbsolutePath();
            }
        }, this.objectMapper);
        Assert.assertArrayEquals((String)"Non-exist root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])extnLoader.getExtensionFilesToLoad());
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_wrong_type_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFile();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config, this.objectMapper);
        extnLoader.getExtensionFilesToLoad();
    }

    @Test
    public void testGetExtensionFilesToLoad_empty_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config, this.objectMapper);
        Assert.assertArrayEquals((String)"Empty root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])extnLoader.getExtensionFilesToLoad());
    }

    @Test
    public void testGetExtensionFilesToLoad_null_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config, this.objectMapper);
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        mysql_metadata_storage.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage};
        Object[] actualFileList = extnLoader.getExtensionFilesToLoad();
        Arrays.sort(actualFileList);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test
    public void testGetExtensionFilesToLoad_with_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        final File absolutePathExtension = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet(Arrays.asList("mysql-metadata-storage", absolutePathExtension.getAbsolutePath()));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        ExtensionsLoader extnLoader = new ExtensionsLoader(config, this.objectMapper);
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        File random_extension = new File(extensionsDir, "random-extensions");
        mysql_metadata_storage.mkdir();
        random_extension.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage, absolutePathExtension};
        Object[] actualFileList = extnLoader.getExtensionFilesToLoad();
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_with_non_exist_item_in_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"mysql-metadata-storage"));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        File random_extension = new File(extensionsDir, "random-extensions");
        random_extension.mkdir();
        ExtensionsLoader extnLoader = new ExtensionsLoader(config, this.objectMapper);
        extnLoader.getExtensionFilesToLoad();
    }

    @Test
    public void testGetURLsForClasspath() throws Exception {
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDir1a = new File(tmpDir1, "a.jar");
        tmpDir1a.createNewFile();
        File tmpDir1b = new File(tmpDir1, "b.jar");
        tmpDir1b.createNewFile();
        new File(tmpDir1, "note1.txt").createNewFile();
        File tmpDir2c = new File(tmpDir2, "c.jar");
        tmpDir2c.createNewFile();
        File tmpDir2d = new File(tmpDir2, "d.jar");
        tmpDir2d.createNewFile();
        File tmpDir2e = new File(tmpDir2, "e.JAR");
        tmpDir2e.createNewFile();
        new File(tmpDir2, "note2.txt").createNewFile();
        String cp = tmpDir1.getAbsolutePath() + File.separator + "*" + File.pathSeparator + tmpDir3.getAbsolutePath() + File.pathSeparator + tmpDir2.getAbsolutePath() + File.separator + "*";
        List urLsForClasspath = ExtensionsLoader.getURLsForClasspath((String)cp);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir1a.toURI().toURL(), tmpDir1b.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(0, 2)));
        Assert.assertEquals((Object)tmpDir3.toURI().toURL(), urLsForClasspath.get(2));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir2c.toURI().toURL(), tmpDir2d.toURI().toURL(), tmpDir2e.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(3, 6)));
    }

    @Test
    public void testExtensionsWithSameDirName() throws Exception {
        String extensionName = "some_extension";
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File extension1 = new File(tmpDir1, "some_extension");
        File extension2 = new File(tmpDir2, "some_extension");
        Assert.assertTrue((boolean)extension1.mkdir());
        Assert.assertTrue((boolean)extension2.mkdir());
        File jar1 = new File(extension1, "jar1.jar");
        File jar2 = new File(extension2, "jar2.jar");
        this.createNewJar(jar1, this.jarFileContents);
        this.createNewJar(jar2, this.jarFileContents);
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(), this.objectMapper);
        StandardURLClassLoader classLoader1 = extnLoader.getClassLoaderForExtension(extension1, false);
        StandardURLClassLoader classLoader2 = extnLoader.getClassLoaderForExtension(extension2, false);
        Assert.assertArrayEquals((Object[])new URL[]{jar1.toURI().toURL()}, (Object[])classLoader1.getURLs());
        Assert.assertArrayEquals((Object[])new URL[]{jar2.toURI().toURL()}, (Object[])classLoader2.getURLs());
    }

    @Test
    public void testGetClassLoaderForExtension_withMissingDependency() throws IOException {
        ExtensionsLoader extnLoader = new ExtensionsLoader(new ExtensionsConfig(), this.objectMapper);
        String druidExtensionDependency = "other-druid-extension";
        DruidExtensionDependencies druidExtensionDependencies = new DruidExtensionDependencies((List)ImmutableList.of((Object)"other-druid-extension"));
        File extensionDir = this.temporaryFolder.newFolder();
        File extensionJar = new File(extensionDir, "a.jar");
        this.createNewJar(extensionJar, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependencies)));
        RE exception = (RE)Assert.assertThrows(RE.class, () -> extnLoader.getClassLoaderForExtension(extensionDir, false));
        Assert.assertEquals((Object)StringUtils.format((String)"Extension [%s] depends on [%s] which is not a valid extension or not loaded.", (Object[])new Object[]{extensionDir.getName(), "other-druid-extension"}), (Object)exception.getMessage());
    }

    @Test
    public void testGetClassLoaderForExtension_dependencyLoaded() throws IOException {
        TestExtensionsConfig extensionsConfig = new TestExtensionsConfig(this.temporaryFolder.getRoot().getPath());
        ExtensionsLoader extnLoader = new ExtensionsLoader((ExtensionsConfig)extensionsConfig, this.objectMapper);
        File extensionDir = this.temporaryFolder.newFolder();
        File extensionJar = new File(extensionDir, "a.jar");
        this.createNewJar(extensionJar, this.jarFileContents);
        File dependentExtensionDir = this.temporaryFolder.newFolder();
        File dependentExtensionJar = new File(dependentExtensionDir, "a.jar");
        DruidExtensionDependencies druidExtensionDependencies = new DruidExtensionDependencies((List)ImmutableList.of((Object)extensionDir.getName()));
        this.createNewJar(dependentExtensionJar, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependencies)));
        StandardURLClassLoader classLoader = extnLoader.getClassLoaderForExtension(extensionDir, false);
        StandardURLClassLoader dependendentClassLoader = extnLoader.getClassLoaderForExtension(dependentExtensionDir, false);
        Assert.assertTrue((boolean)dependendentClassLoader.getExtensionDependencyClassLoaders().contains(classLoader));
        Assert.assertEquals((long)0L, (long)classLoader.getExtensionDependencyClassLoaders().size());
    }

    @Test
    public void testGetClassLoaderForExtension_circularDependency() throws IOException {
        TestExtensionsConfig extensionsConfig = new TestExtensionsConfig(this.temporaryFolder.getRoot().getPath());
        ExtensionsLoader extnLoader = new ExtensionsLoader((ExtensionsConfig)extensionsConfig, this.objectMapper);
        File extensionDir = this.temporaryFolder.newFolder();
        File dependentExtensionDir = this.temporaryFolder.newFolder();
        File extensionJar = new File(extensionDir, "a.jar");
        DruidExtensionDependencies druidExtensionDependencies = new DruidExtensionDependencies((List)ImmutableList.of((Object)dependentExtensionDir.getName()));
        this.createNewJar(extensionJar, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependencies)));
        File dependentExtensionJar = new File(dependentExtensionDir, "a.jar");
        DruidExtensionDependencies druidExtensionDependenciesCircular = new DruidExtensionDependencies((List)ImmutableList.of((Object)extensionDir.getName()));
        this.createNewJar(dependentExtensionJar, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependenciesCircular)));
        RE exception = (RE)Assert.assertThrows(RE.class, () -> extnLoader.getClassLoaderForExtension(extensionDir, false));
        Assert.assertTrue((boolean)exception.getMessage().contains("has a circular druid extension dependency."));
    }

    @Test
    public void testGetClassLoaderForExtension_multipleDruidJars() throws IOException {
        TestExtensionsConfig extensionsConfig = new TestExtensionsConfig(this.temporaryFolder.getRoot().getPath());
        ExtensionsLoader extnLoader = new ExtensionsLoader((ExtensionsConfig)extensionsConfig, this.objectMapper);
        File extensionDir = this.temporaryFolder.newFolder();
        File extensionJar = new File(extensionDir, "a.jar");
        DruidExtensionDependencies druidExtensionDependencies = new DruidExtensionDependencies((List)ImmutableList.of());
        this.createNewJar(extensionJar, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependencies)));
        File extensionJar2 = new File(extensionDir, "b.jar");
        this.createNewJar(extensionJar2, (Map<String, byte[]>)ImmutableMap.of((Object)"druid-extension-dependencies.json", (Object)this.objectMapper.writeValueAsBytes((Object)druidExtensionDependencies)));
        RE exception = (RE)Assert.assertThrows(RE.class, () -> extnLoader.getClassLoaderForExtension(extensionDir, false));
        Assert.assertTrue((boolean)exception.getMessage().contains("Each jar should be in a separate extension directory."));
    }

    private void createNewJar(File jarFileLocation, Map<String, byte[]> jarFileContents) throws IOException {
        Assert.assertTrue((boolean)jarFileLocation.createNewFile());
        FileOutputStream fos = new FileOutputStream(jarFileLocation.getPath());
        JarOutputStream jarOut = new JarOutputStream(fos);
        for (Map.Entry<String, byte[]> fileNameToContents : jarFileContents.entrySet()) {
            JarEntry entry = new JarEntry(fileNameToContents.getKey());
            jarOut.putNextEntry(entry);
            jarOut.write(fileNameToContents.getValue());
            jarOut.closeEntry();
        }
        jarOut.close();
        fos.close();
    }

    private static class TestExtensionsConfig
    extends ExtensionsConfig {
        final String directory;

        public TestExtensionsConfig(String directory) {
            this.directory = directory;
        }

        public String getDirectory() {
            return this.directory;
        }
    }
}

