/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DimensionRangePartitionsSpecTest {
    private static final Integer TARGET_ROWS_PER_SEGMENT = 1;
    private static final Integer MAX_ROWS_PER_SEGMENT = null;
    private static final Integer HISTORICAL_NULL = -1;
    private static final List<String> PARTITION_DIMENSIONS = Arrays.asList("a", "b");
    private static final boolean ASSUME_GROUPED = false;
    private static final DimensionRangePartitionsSpec SPEC = new DimensionRangePartitionsSpec(TARGET_ROWS_PER_SEGMENT, MAX_ROWS_PER_SEGMENT, PARTITION_DIMENSIONS, false);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void serde() {
        String json = DimensionRangePartitionsSpecTest.serialize(SPEC);
        DimensionRangePartitionsSpec spec = DimensionRangePartitionsSpecTest.deserialize(json);
        Assert.assertEquals((Object)SPEC, (Object)spec);
    }

    @Test
    public void havingNeitherTargetNorMaxForbidden() {
        new TestSpecBuilder().testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void targetRowsPerSegmentMustBePositive() {
        new TestSpecBuilder().targetRowsPerSegment(0).testIllegalArgumentException("targetRowsPerSegment must be greater than 0");
    }

    @Test
    public void targetRowsPerSegmentHistoricalNull() {
        new TestSpecBuilder().targetRowsPerSegment(HISTORICAL_NULL).testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void targetMaxRowsPerSegmentOverflows() {
        new TestSpecBuilder().targetRowsPerSegment(Integer.MAX_VALUE).testIllegalArgumentException("targetRowsPerSegment is too large");
    }

    @Test
    public void maxRowsPerSegmentMustBePositive() {
        new TestSpecBuilder().maxRowsPerSegment(0).testIllegalArgumentException("maxRowsPerSegment must be greater than 0");
    }

    @Test
    public void maxRowsPerSegmentHistoricalNull() {
        new TestSpecBuilder().maxRowsPerSegment(HISTORICAL_NULL).testIllegalArgumentException("Exactly one of targetRowsPerSegment or maxRowsPerSegment must be present");
    }

    @Test
    public void resolvesMaxFromTargetRowsPerSegment() {
        DimensionRangePartitionsSpec spec = new TestSpecBuilder().targetRowsPerSegment(123).build();
        Assert.assertEquals((long)184L, (long)spec.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void resolvesMaxFromMaxRowsPerSegment() {
        DimensionRangePartitionsSpec spec = new TestSpecBuilder().maxRowsPerSegment(123).build();
        Assert.assertEquals((long)123L, (long)spec.getMaxRowsPerSegment().intValue());
    }

    @Test
    public void getPartitionDimensionFromNull() {
        new TestSpecBuilder().partitionDimensions(null).testIllegalArgumentException("partitionDimensions must be specified");
    }

    @Test
    public void getPartitionDimensionFromNonNull() {
        List<String> partitionDimensions = Collections.singletonList("a");
        DimensionRangePartitionsSpec spec = new TestSpecBuilder().targetRowsPerSegment(10).partitionDimensions(partitionDimensions).build();
        Assert.assertEquals(partitionDimensions, (Object)spec.getPartitionDimensions());
    }

    private static String serialize(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static DimensionRangePartitionsSpec deserialize(String serialized) {
        try {
            return (DimensionRangePartitionsSpec)OBJECT_MAPPER.readValue(serialized, DimensionRangePartitionsSpec.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class TestSpecBuilder {
        private Integer targetRowsPerSegment;
        private Integer maxRowsPerSegment;
        private List<String> partitionDimensions = Collections.emptyList();

        private TestSpecBuilder() {
        }

        TestSpecBuilder targetRowsPerSegment(Integer targetRowsPerSegment) {
            this.targetRowsPerSegment = targetRowsPerSegment;
            return this;
        }

        TestSpecBuilder maxRowsPerSegment(Integer maxRowsPerSegment) {
            this.maxRowsPerSegment = maxRowsPerSegment;
            return this;
        }

        TestSpecBuilder partitionDimensions(List<String> partitionDimensions) {
            this.partitionDimensions = partitionDimensions;
            return this;
        }

        void testIllegalArgumentException(String exceptionExpectedMessage) {
            DimensionRangePartitionsSpecTest.this.exception.expect(IllegalArgumentException.class);
            DimensionRangePartitionsSpecTest.this.exception.expectMessage(exceptionExpectedMessage);
            this.build();
        }

        DimensionRangePartitionsSpec build() {
            return new DimensionRangePartitionsSpec(this.targetRowsPerSegment, this.maxRowsPerSegment, this.partitionDimensions, false);
        }
    }
}

