/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import java.io.File;
import java.io.IOException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CpuSetTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private CgroupDiscoverer discoverer;
    private File cpusetDir;

    @Before
    public void setUp() throws IOException {
        File cgroupDir = this.temporaryFolder.newFolder();
        File procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(procDir.toPath());
        TestUtils.setUpCgroups(procDir, cgroupDir);
        this.cpusetDir = new File(cgroupDir, "cpuset/system.slice/some.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee");
        FileUtils.mkdirp((File)this.cpusetDir);
        TestUtils.copyOrReplaceResource("/cpuset.cpus", new File(this.cpusetDir, "cpuset.cpus"));
        TestUtils.copyOrReplaceResource("/cpuset.mems", new File(this.cpusetDir, "cpuset.mems"));
        TestUtils.copyOrReplaceResource("/cpuset.effective_mems", new File(this.cpusetDir, "cpuset.effective_mems"));
    }

    @Test
    public void testWontCrash() {
        CpuSet cpuSet = new CpuSet(cgroup -> {
            throw new RuntimeException("Should still continue");
        });
        CpuSet.CpuSetMetric metric = cpuSet.snapshot();
        Assert.assertEquals((long)0L, (long)metric.getCpuSetCpus().length);
        Assert.assertEquals((long)0L, (long)metric.getEffectiveCpuSetCpus().length);
        Assert.assertEquals((long)0L, (long)metric.getCpuSetMems().length);
        Assert.assertEquals((long)0L, (long)metric.getEffectiveCpuSetMems().length);
    }

    @Test
    public void testSimpleLoad() throws IOException {
        TestUtils.copyOrReplaceResource("/cpuset.effective_cpus.simple", new File(this.cpusetDir, "cpuset.effective_cpus"));
        CpuSet cpuSet = new CpuSet(this.discoverer);
        CpuSet.CpuSetMetric snapshot = cpuSet.snapshot();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])snapshot.getCpuSetCpus());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])snapshot.getEffectiveCpuSetCpus());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])snapshot.getCpuSetMems());
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])snapshot.getEffectiveCpuSetMems());
    }

    @Test
    public void testComplexLoad() throws IOException {
        TestUtils.copyOrReplaceResource("/cpuset.effective_cpus.complex", new File(this.cpusetDir, "cpuset.effective_cpus"));
        CpuSet cpuSet = new CpuSet(this.discoverer);
        CpuSet.CpuSetMetric snapshot = cpuSet.snapshot();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])snapshot.getCpuSetCpus());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 7, 12, 13, 14}, (int[])snapshot.getEffectiveCpuSetCpus());
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])snapshot.getCpuSetMems());
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])snapshot.getEffectiveCpuSetMems());
    }
}

