/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.matchers;

import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

public class LambdaMatcher<T, S>
extends DiagnosingMatcher<T> {
    private final String name;
    private final Function<T, S> fn;
    private final Matcher<S> matcher;

    public LambdaMatcher(String name, Function<T, S> fn, Matcher<S> matcher) {
        this.name = name;
        this.fn = fn;
        this.matcher = matcher;
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        S result = this.fn.apply(item);
        if (!this.matcher.matches(result)) {
            this.matcher.describeMismatch(result, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.name);
        this.matcher.describeTo(description);
    }
}

