/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class OutputTypeTest
extends InitializedNullHandlingTest {
    private final Expr.InputBindingInspector inspector = this.inspectorFromMap((Map<String, ExpressionType>)ImmutableMap.builder().put((Object)"x", (Object)ExpressionType.STRING).put((Object)"x_", (Object)ExpressionType.STRING).put((Object)"y", (Object)ExpressionType.LONG).put((Object)"y_", (Object)ExpressionType.LONG).put((Object)"z", (Object)ExpressionType.DOUBLE).put((Object)"z_", (Object)ExpressionType.DOUBLE).put((Object)"a", (Object)ExpressionType.STRING_ARRAY).put((Object)"a_", (Object)ExpressionType.STRING_ARRAY).put((Object)"b", (Object)ExpressionType.LONG_ARRAY).put((Object)"b_", (Object)ExpressionType.LONG_ARRAY).put((Object)"c", (Object)ExpressionType.DOUBLE_ARRAY).put((Object)"c_", (Object)ExpressionType.DOUBLE_ARRAY).build());

    @Test
    public void testConstantsAndIdentifiers() {
        this.assertOutputType("'hello'", this.inspector, ExpressionType.STRING);
        this.assertOutputType("23", this.inspector, ExpressionType.LONG);
        this.assertOutputType("3.2", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("['a', 'b']", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("[1,2,3]", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("[1.0]", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("x", this.inspector, ExpressionType.STRING);
        this.assertOutputType("y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("a", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("b", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("c", this.inspector, ExpressionType.DOUBLE_ARRAY);
    }

    @Test
    public void testUnaryOperators() {
        this.assertOutputType("-1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("-1.1", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("-y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("-z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("!'true'", this.inspector, ExpressionType.LONG);
        this.assertOutputType("!1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("!x", this.inspector, ExpressionType.LONG);
        this.assertOutputType("!y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("!1.1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("!z", this.inspector, ExpressionType.LONG);
    }

    @Test
    public void testBinaryMathOperators() {
        this.assertOutputType("1+1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1-1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1*1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1/1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1^1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1%1", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y+y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y-y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y*y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y/y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y^y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y%y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y+z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y-z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y*z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y/z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y^z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y%z", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z+z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z-z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z*z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z/z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z^z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("z%z_", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("y>y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_<y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_<=y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_>=y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_==y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_!=y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_ && y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y_ || y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z>y_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z<y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z<=y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y>=z", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z==y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z!=y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z && y", this.inspector, ExpressionType.LONG);
        this.assertOutputType("y || z", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z>z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z<z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z<=z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z_>=z", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z==z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z!=z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z && z_", this.inspector, ExpressionType.LONG);
        this.assertOutputType("z_ || z", this.inspector, ExpressionType.LONG);
        this.assertOutputType("1*(2 + 3.0)", this.inspector, ExpressionType.DOUBLE);
    }

    @Test
    public void testUnivariateMathFunctions() {
        this.assertOutputType("pi()", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("abs(x)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("abs(y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("abs(z)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("cos(y)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("cos(z)", this.inspector, ExpressionType.DOUBLE);
    }

    @Test
    public void testBivariateMathFunctions() {
        this.assertOutputType("div(y,y_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("div(y,z_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("div(z,z_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("max(y,y_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("max(y,z_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("max(z,z_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("hypot(y,y_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("hypot(y,z_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("hypot(z,z_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("safe_divide(y,y_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("safe_divide(y,z_)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("safe_divide(z,z_)", this.inspector, ExpressionType.DOUBLE);
    }

    @Test
    public void testConditionalFunctions() {
        this.assertOutputType("if(y, 'foo', 'bar')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("if(y,2,3)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("if(y,2,3.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_simple(x,'baz','is baz','foo','is foo','is other')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("case_simple(y,2,2,3,3,4)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("case_simple(z,2.0,2.0,3.0,3.0,4.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_simple(y,2,2,3,3.0,4)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_simple(z,2.0,2.0,3.0,3.0,null)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_searched(x=='baz','is baz',x=='foo','is foo','is other')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("case_searched(y==1,1,y==2,2,0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("case_searched(z==1.0,1.0,z==2.0,2.0,0.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_searched(y==1,1,y==2,2.0,0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("case_searched(z==1.0,1,z==2.0,2,null)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("case_searched(z==1.0,1.0,z==2.0,2.0,null)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("nvl(x, 'foo')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("nvl(y, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("nvl(y, 1.1)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("nvl(z, 2.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("nvl(y, 2.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("isnull(x)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("isnull(y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("isnull(z)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("notnull(x)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("notnull(y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("notnull(z)", this.inspector, ExpressionType.LONG);
    }

    @Test
    public void testStringFunctions() {
        this.assertOutputType("concat(x, 'foo')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("concat(y, 'foo')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("concat(z, 'foo')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("strlen(x)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("format('%s', x)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("format('%s', y)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("format('%s', z)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("strpos(x, x_)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("strpos(x, y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("strpos(x, z)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("substring(x, 1, 2)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("left(x, 1)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("right(x, 1)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("replace(x, 'foo', '')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("lower(x)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("upper(x)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("reverse(x)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("repeat(x, 4)", this.inspector, ExpressionType.STRING);
    }

    @Test
    public void testArrayFunctions() {
        this.assertOutputType("array(1, 2, 3)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array(1, 2, 3.0)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array(a, b)", this.inspector, ExpressionTypeFactory.getInstance().ofArray(ExpressionType.STRING_ARRAY));
        this.assertOutputType("array_length(a)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_length(b)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_length(c)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("string_to_array(x, ',')", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_to_string(a, ',')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("array_to_string(b, ',')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("array_to_string(c, ',')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("array_offset(a, 1)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("array_offset(b, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_offset(c, 1)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("array_ordinal(a, 1)", this.inspector, ExpressionType.STRING);
        this.assertOutputType("array_ordinal(b, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_ordinal(c, 1)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("array_offset_of(a, 'a')", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_offset_of(b, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_offset_of(c, 1.0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_ordinal_of(a, 'a')", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_ordinal_of(b, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_ordinal_of(c, 1.0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_append(x, x_)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_append(a, x_)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_append(y, y_)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_append(b, y_)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_append(z, z_)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_append(c, z_)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_concat(x, a)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_concat(a, a)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_concat(y, b)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_concat(b, b)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_concat(z, c)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_concat(c, c)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_contains(a, 'a')", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_contains(b, 1)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_contains(c, 2.0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_overlap(a, a)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_overlap(b, b)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_overlap(c, c)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("array_slice(a, 1, 2)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_slice(b, 1, 2)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_slice(c, 1, 2)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_prepend(x, a)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_prepend(x, x_)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("array_prepend(y, b)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_prepend(y, y_)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("array_prepend(z, c)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("array_prepend(z, z_)", this.inspector, ExpressionType.DOUBLE_ARRAY);
    }

    @Test
    public void testReduceFunctions() {
        this.assertOutputType("greatest('B', x, 'A')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("greatest(y, 0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("greatest(34.0, z, 5.0, 767.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("least('B', x, 'A')", this.inspector, ExpressionType.STRING);
        this.assertOutputType("least(y, 0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("least(34.0, z, 5.0, 767.0)", this.inspector, ExpressionType.DOUBLE);
    }

    @Test
    public void testApplyFunctions() {
        this.assertOutputType("map((x) -> concat(x, 'foo'), x)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("map((x) -> x + x, y)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("map((x) -> x + x, z)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("map((x) -> concat(x, 'foo'), a)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("map((x) -> x + x, b)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("map((x) -> x + x, c)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("cartesian_map((x, y) -> concat(x, y), ['foo', 'bar', 'baz', 'foobar'], ['bar', 'baz'])", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("fold((x, acc) -> x + acc, y, 0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("fold((x, acc) -> x + acc, y, y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("fold((x, acc) -> x + acc, y, 1.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("fold((x, acc) -> x + acc, y, z)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("cartesian_fold((x, y, acc) -> x + y + acc, y, z, 0)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("cartesian_fold((x, y, acc) -> x + y + acc, y, z, y)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("cartesian_fold((x, y, acc) -> x + y + acc, y, z, 1.0)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("cartesian_fold((x, y, acc) -> x + y + acc, y, z, z)", this.inspector, ExpressionType.DOUBLE);
        this.assertOutputType("filter((x) -> x == 'foo', a)", this.inspector, ExpressionType.STRING_ARRAY);
        this.assertOutputType("filter((x) -> x > 1, b)", this.inspector, ExpressionType.LONG_ARRAY);
        this.assertOutputType("filter((x) -> x > 1, c)", this.inspector, ExpressionType.DOUBLE_ARRAY);
        this.assertOutputType("any((x) -> x == 'foo', a)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("any((x) -> x > 1, b)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("any((x) -> x > 1.2, c)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("all((x) -> x == 'foo', a)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("all((x) -> x > 1, b)", this.inspector, ExpressionType.LONG);
        this.assertOutputType("all((x) -> x > 1.2, c)", this.inspector, ExpressionType.LONG);
    }

    @Test
    public void testEvalAutoConversion() {
        ExprEval nullStringEval = ExprEval.of(null);
        ExprEval stringEval = ExprEval.of((String)"wat");
        ExprEval longEval = ExprEval.of((long)1L);
        ExprEval doubleEval = ExprEval.of((double)1.0);
        ExprEval arrayEval = ExprEval.ofLongArray((Object[])new Long[]{1L, 2L, 3L});
        ExprEval complexEval = ExprEval.ofComplex((ExpressionType)ExpressionType.UNKNOWN_COMPLEX, (Object)new Object());
        ExprEval complexEval2 = ExprEval.ofComplex((ExpressionType)new ExpressionType(ExprType.COMPLEX, null, null), (Object)new Object());
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)longEval));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.autoDetect((ExprEval)nullStringEval, (ExprEval)nullStringEval));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.autoDetect((ExprEval)stringEval, (ExprEval)stringEval));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.autoDetect((ExprEval)nullStringEval, (ExprEval)longEval));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)nullStringEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)nullStringEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)nullStringEval, (ExprEval)doubleEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)doubleEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)longEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)doubleEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)stringEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)stringEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)stringEval, (ExprEval)doubleEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)arrayEval, (ExprEval)nullStringEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)arrayEval, (ExprEval)doubleEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)arrayEval, (ExprEval)longEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)nullStringEval, (ExprEval)arrayEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)arrayEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)arrayEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)longEval, (ExprEval)complexEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)doubleEval, (ExprEval)complexEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)arrayEval, (ExprEval)complexEval));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.autoDetect((ExprEval)complexEval, (ExprEval)complexEval));
        Assert.assertEquals((Object)ExpressionTypeConversion.autoDetect((ExprEval)complexEval, (ExprEval)complexEval), (Object)ExpressionTypeConversion.autoDetect((ExprEval)complexEval2, (ExprEval)complexEval));
    }

    @Test
    public void testOperatorAutoConversion() {
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG, null));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.operator(null, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.DOUBLE, null));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator(null, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING, null));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.operator(null, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.DOUBLE_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING_ARRAY, (ExpressionType)ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.STRING_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        ExpressionType nested = ExpressionType.fromColumnType((TypeSignature)ColumnType.NESTED_DATA);
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.operator((ExpressionType)nested, (ExpressionType)nested));
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.operator((ExpressionType)nested, (ExpressionType)ExpressionType.UNKNOWN_COMPLEX));
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.operator((ExpressionType)ExpressionType.UNKNOWN_COMPLEX, (ExpressionType)nested));
    }

    @Test
    public void testFunctionAutoConversion() {
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG, null));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.function(null, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE, null));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.function(null, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING, null));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function(null, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.DOUBLE, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING_ARRAY, (ExpressionType)ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE_ARRAY, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.DOUBLE_ARRAY, (ExpressionType)ExpressionType.STRING_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING_ARRAY, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        ExpressionType nested = ExpressionType.fromColumnType((TypeSignature)ColumnType.NESTED_DATA);
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.function((ExpressionType)nested, (ExpressionType)nested));
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.function((ExpressionType)nested, (ExpressionType)ExpressionType.UNKNOWN_COMPLEX));
        Assert.assertEquals((Object)nested, (Object)ExpressionTypeConversion.function((ExpressionType)ExpressionType.UNKNOWN_COMPLEX, (ExpressionType)nested));
    }

    @Test
    public void testIntegerFunctionAutoConversion() {
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.LONG, null));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction(null, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.DOUBLE, null));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction(null, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.STRING, null));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction(null, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.LONG, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.LONG, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.LONG));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.DOUBLE, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.DOUBLE));
        Assert.assertEquals((Object)ExpressionType.STRING, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.STRING, (ExpressionType)ExpressionType.STRING));
        Assert.assertEquals((Object)ExpressionType.LONG_ARRAY, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.LONG_ARRAY, (ExpressionType)ExpressionType.LONG_ARRAY));
        Assert.assertEquals((Object)ExpressionType.DOUBLE_ARRAY, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.DOUBLE_ARRAY, (ExpressionType)ExpressionType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ExpressionType.STRING_ARRAY, (Object)ExpressionTypeConversion.integerMathFunction((ExpressionType)ExpressionType.STRING_ARRAY, (ExpressionType)ExpressionType.STRING_ARRAY));
    }

    private void assertOutputType(String expression, Expr.InputBindingInspector inspector, ExpressionType outputType) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false);
        Assert.assertEquals((Object)outputType, (Object)expr.getOutputType(inspector));
    }

    Expr.InputBindingInspector inspectorFromMap(Map<String, ExpressionType> types) {
        return key -> (ExpressionType)types.get(key);
    }
}

