/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.SettableObjectBinding;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.expression.NestedDataExpressions;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class VectorExprSanityTest
extends InitializedNullHandlingTest {
    private static final Logger log = new Logger(VectorExprSanityTest.class);
    private static final int NUM_ITERATIONS = 10;
    private static final int VECTOR_SIZE = 512;
    private static final ExprMacroTable MACRO_TABLE = new ExprMacroTable((List)ImmutableList.of((Object)new NestedDataExpressions.JsonObjectExprMacro()));
    final Map<String, ExpressionType> types = ImmutableMap.builder().put((Object)"l1", (Object)ExpressionType.LONG).put((Object)"l2", (Object)ExpressionType.LONG).put((Object)"d1", (Object)ExpressionType.DOUBLE).put((Object)"d2", (Object)ExpressionType.DOUBLE).put((Object)"s1", (Object)ExpressionType.STRING).put((Object)"s2", (Object)ExpressionType.STRING).put((Object)"boolString1", (Object)ExpressionType.STRING).put((Object)"boolString2", (Object)ExpressionType.STRING).build();

    @Test
    public void testUnaryOperators() {
        String[] functions = new String[]{"-"};
        String[] templates = new String[]{"%sd1", "%sl1"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryMathOperators() {
        String[] columns = new String[]{"d1", "d2", "l1", "l2", "1", "1.0", "nonexistent", "null", "s1"};
        String[] columns2 = new String[]{"d1", "d2", "l1", "l2", "1", "1.0"};
        String[][] templateInputs = VectorExprSanityTest.makeTemplateArgs(columns, columns2);
        String[] templates = (String[])Arrays.stream(templateInputs).map(i -> StringUtils.format((String)"%s %s %s", (Object[])new Object[]{i[0], "%s", i[1]})).toArray(String[]::new);
        String[] args = new String[]{"+", "-", "*", "/", "^", "%"};
        VectorExprSanityTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testBinaryComparisonOperators() {
        String[] columns = new String[]{"d1", "d2", "l1", "l2", "1", "1.0", "s1", "s2", "nonexistent", "null"};
        String[] columns2 = new String[]{"d1", "d2", "l1", "l2", "1", "1.0", "s1", "s2", "null"};
        String[][] templateInputs = VectorExprSanityTest.makeTemplateArgs(columns, columns2);
        String[] templates = (String[])Arrays.stream(templateInputs).map(i -> StringUtils.format((String)"%s %s %s", (Object[])new Object[]{i[0], "%s", i[1]})).toArray(String[]::new);
        String[] args = new String[]{">", ">=", "<", "<=", "==", "!="};
        VectorExprSanityTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testUnaryLogicOperators() {
        String[] functions = new String[]{"!"};
        String[] templates = new String[]{"%sd1", "%sl1", "%sboolString1"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryLogicOperators() {
        String[] functions = new String[]{"&&", "||"};
        String[] templates = new String[]{"d1 %s d2", "l1 %s l2", "boolString1 %s boolString2", "(d1 == d2) %s (l1 == l2)"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBinaryOperatorTrees() {
        String[] columns = new String[]{"d1", "l1", "1", "1.0", "nonexistent", "null"};
        String[] columns2 = new String[]{"d2", "l2", "2", "2.0"};
        String[][] templateInputs = VectorExprSanityTest.makeTemplateArgs(columns, columns2, columns2);
        String[] templates = (String[])Arrays.stream(templateInputs).map(i -> StringUtils.format((String)"(%s %s %s) %s %s", (Object[])new Object[]{i[0], "%s", i[1], "%s", i[2]})).toArray(String[]::new);
        String[] ops = new String[]{"+", "-", "*", "/"};
        String[][] args = VectorExprSanityTest.makeTemplateArgs(ops, ops);
        VectorExprSanityTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testUnivariateFunctions() {
        String[] functions = new String[]{"parse_long", "isNull", "notNull"};
        String[] templates = new String[]{"%s(s1)", "%s(l1)", "%s(d1)", "%s(nonexistent)", "%s(null)"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testUnivariateMathFunctions() {
        String[] functions = new String[]{"abs", "acos", "asin", "atan", "cbrt", "ceil", "cos", "cosh", "cot", "exp", "expm1", "floor", "getExponent", "log", "log10", "log1p", "nextUp", "rint", "signum", "sin", "sinh", "sqrt", "tan", "tanh", "toDegrees", "toRadians", "ulp", "bitwiseComplement", "bitwiseConvertDoubleToLongBits", "bitwiseConvertLongBitsToDouble"};
        String[] templates = new String[]{"%s(l1)", "%s(d1)", "%s(pi())", "%s(null)", "%s(missing)"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testBivariateMathFunctions() {
        String[] functions = new String[]{"atan2", "copySign", "div", "hypot", "remainder", "max", "min", "nextAfter", "scalb", "pow", "bitwiseAnd", "bitwiseOr", "bitwiseXor", "bitwiseShiftLeft", "bitwiseShiftRight"};
        String[] templates = new String[]{"%s(d1, d2)", "%s(d1, l1)", "%s(l1, d1)", "%s(l1, l2)", "%s(nonexistent, l1)", "%s(nonexistent, d1)"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testSymmetricalBivariateFunctions() {
        String[] functions = new String[]{"nvl"};
        String[] templates = new String[]{"%s(d1, d2)", "%s(l1, l2)", "%s(s1, s2)", "%s(nonexistent, l1)", "%s(nonexistent, d1)", "%s(nonexistent, s1)"};
        VectorExprSanityTest.testFunctions(this.types, templates, functions);
    }

    @Test
    public void testCast() {
        String[] columns = new String[]{"d1", "l1", "s1"};
        String[] castTo = new String[]{"'STRING'", "'LONG'", "'DOUBLE'", "'ARRAY<STRING>'", "'ARRAY<LONG>'", "'ARRAY<DOUBLE>'"};
        String[][] args = VectorExprSanityTest.makeTemplateArgs(columns, castTo);
        String[] templates = new String[]{"cast(%s, %s)"};
        VectorExprSanityTest.testFunctions(this.types, templates, args);
    }

    @Test
    public void testStringFns() {
        VectorExprSanityTest.testExpression("s1 + s2", this.types);
        VectorExprSanityTest.testExpression("s1 + '-' + s2", this.types);
        VectorExprSanityTest.testExpression("concat(s1, s2)", this.types);
        VectorExprSanityTest.testExpression("concat(s1,'-',s2,'-',l1,'-',d1)", this.types);
    }

    @Test
    public void testArrayFns() {
        try {
            ExpressionProcessing.initializeForFallback();
            VectorExprSanityTest.testExpression("array(s1, s2)", this.types);
            VectorExprSanityTest.testExpression("array(l1, l2)", this.types);
            VectorExprSanityTest.testExpression("array(d1, d2)", this.types);
            VectorExprSanityTest.testExpression("array(l1, d2)", this.types);
            VectorExprSanityTest.testExpression("array(s1, l2)", this.types);
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
    }

    @Test
    public void testCastArraysRoundTrip() {
        VectorExprSanityTest.testExpression("cast(cast(s1, 'ARRAY<STRING>'), 'STRING')", this.types);
        VectorExprSanityTest.testExpression("cast(cast(d1, 'ARRAY<DOUBLE>'), 'DOUBLE')", this.types);
        VectorExprSanityTest.testExpression("cast(cast(d1, 'ARRAY<STRING>'), 'DOUBLE')", this.types);
        VectorExprSanityTest.testExpression("cast(cast(l1, 'ARRAY<LONG>'), 'LONG')", this.types);
        VectorExprSanityTest.testExpression("cast(cast(l1, 'ARRAY<STRING>'), 'LONG')", this.types);
    }

    @Test
    public void testJsonFns() {
        Assume.assumeTrue((boolean)ExpressionProcessing.allowVectorizeFallback());
        VectorExprSanityTest.testExpression("json_object('k1', s1, 'k2', l1)", this.types);
    }

    @Test
    public void testConstants() {
        VectorExprSanityTest.testExpression("null", this.types);
        VectorExprSanityTest.testExpression("1", this.types);
        VectorExprSanityTest.testExpression("1.1", this.types);
        VectorExprSanityTest.testExpression("NaN", this.types);
        VectorExprSanityTest.testExpression("Infinity", this.types);
        VectorExprSanityTest.testExpression("-Infinity", this.types);
        VectorExprSanityTest.testExpression("'hello'", this.types);
        VectorExprSanityTest.testExpression("json_object('a', 1, 'b', 'abc', 'c', 3.3, 'd', array(1,2,3))", this.types);
    }

    static void testFunctions(Map<String, ExpressionType> types, String[] templates, String[] args) {
        for (String template : templates) {
            for (String arg : args) {
                String expr = StringUtils.format((String)template, (Object[])new Object[]{arg});
                VectorExprSanityTest.testExpression(expr, types);
            }
        }
    }

    static void testFunctions(Map<String, ExpressionType> types, String[] templates, String[][] argsArrays) {
        for (String template : templates) {
            for (Object[] objectArray : argsArrays) {
                String expr = StringUtils.format((String)template, (Object[])objectArray);
                VectorExprSanityTest.testExpression(expr, types);
            }
        }
    }

    static void testExpression(String expr, Map<String, ExpressionType> types) {
        log.debug("[%s]", new Object[]{expr});
        Expr parsed = Parser.parse((String)expr, (ExprMacroTable)MACRO_TABLE);
        VectorExprSanityTest.testExpression(expr, parsed, types, 10);
        VectorExprSanityTest.testSequentialBinding(expr, parsed, types);
    }

    public static void testSequentialBinding(String expr, Expr parsed, Map<String, ExpressionType> types) {
        NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> bindings = VectorExprSanityTest.makeSequentialBinding(512, types);
        Assert.assertTrue((String)StringUtils.format((String)"Cannot vectorize %s", (Object[])new Object[]{expr}), (boolean)parsed.canVectorize((Expr.InputBindingInspector)bindings.rhs));
        ExpressionType outputType = parsed.getOutputType((Expr.InputBindingInspector)bindings.rhs);
        ExprEvalVector vectorEval = parsed.asVectorProcessor((Expr.VectorInputBindingInspector)bindings.rhs).evalVector((Expr.VectorInputBinding)bindings.rhs);
        if (outputType != null) {
            Assert.assertEquals((String)expr, (Object)outputType, (Object)vectorEval.getType());
        }
        Object[] vectorVals = vectorEval.getObjectVector();
        for (int i = 0; i < 512; ++i) {
            ExprEval eval = parsed.eval(((Expr.ObjectBinding[])bindings.lhs)[i]);
            if (outputType != null && !eval.isNumericNull()) {
                Assert.assertEquals((Object)eval.type(), (Object)outputType);
            }
            if (outputType != null && outputType.isArray()) {
                Assert.assertArrayEquals((String)StringUtils.format((String)"Values do not match for row %s for expression %s", (Object[])new Object[]{i, expr}), (Object[])((Object[])eval.valueOrDefault()), (Object[])((Object[])vectorVals[i]));
                continue;
            }
            Assert.assertEquals((String)StringUtils.format((String)"Values do not match for row %s for expression %s", (Object[])new Object[]{i, expr}), (Object)eval.valueOrDefault(), (Object)vectorVals[i]);
        }
    }

    public static void testExpression(String expr, Expr parsed, Map<String, ExpressionType> types, int numIterations) {
        final Expr.InputBindingInspector inspector = InputBindings.inspectorFromTypeMap(types);
        Expr.VectorInputBindingInspector vectorInputBindingInspector = new Expr.VectorInputBindingInspector(){

            public int getMaxVectorSize() {
                return 512;
            }

            @Nullable
            public ExpressionType getType(String name) {
                return inspector.getType(name);
            }
        };
        Assert.assertTrue((String)StringUtils.format((String)"Cannot vectorize %s", (Object[])new Object[]{expr}), (boolean)parsed.canVectorize(inspector));
        ExpressionType outputType = parsed.getOutputType(inspector);
        ExprVectorProcessor processor = parsed.asVectorProcessor(vectorInputBindingInspector);
        if (outputType != null) {
            Assert.assertEquals((String)expr, (Object)outputType, (Object)processor.getOutputType());
        }
        for (int iterations = 0; iterations < numIterations; ++iterations) {
            NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> bindings = VectorExprSanityTest.makeRandomizedBindings(512, types);
            ExprEvalVector vectorEval = processor.evalVector((Expr.VectorInputBinding)bindings.rhs);
            Object[] vectorVals = vectorEval.getObjectVector();
            for (int i = 0; i < 512; ++i) {
                ExprEval eval = parsed.eval(((Expr.ObjectBinding[])bindings.lhs)[i]);
                if (outputType != null && !eval.isNumericNull()) {
                    Assert.assertEquals((Object)eval.type(), (Object)outputType);
                }
                if (outputType != null && outputType.isArray()) {
                    Assert.assertArrayEquals((String)StringUtils.format((String)"Values do not match for row %s for expression %s", (Object[])new Object[]{i, expr}), (Object[])((Object[])eval.valueOrDefault()), (Object[])((Object[])vectorVals[i]));
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"Values do not match for row %s for expression %s", (Object[])new Object[]{i, expr}), (Object)eval.valueOrDefault(), (Object)vectorVals[i]);
            }
        }
    }

    public static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> makeRandomizedBindings(int vectorSize, Map<String, ExpressionType> types) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return VectorExprSanityTest.makeBindings(vectorSize, types, () -> r.nextLong(0x7FFFFFFEL), r::nextDouble, () -> r.nextDouble(0.0, 1.0) > 0.9, () -> String.valueOf(r.nextInt()));
    }

    public static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> makeSequentialBinding(int vectorSize, Map<String, ExpressionType> types) {
        return VectorExprSanityTest.makeBindings(vectorSize, types, new LongSupplier(){
            int counter = 1;

            @Override
            public long getAsLong() {
                return this.counter++;
            }
        }, new DoubleSupplier(){
            int counter = 1;

            @Override
            public double getAsDouble() {
                return this.counter++;
            }
        }, () -> ThreadLocalRandom.current().nextBoolean(), new Supplier<String>(){
            int counter = 1;

            @Override
            public String get() {
                return String.valueOf(this.counter++);
            }
        });
    }

    static NonnullPair<Expr.ObjectBinding[], Expr.VectorInputBinding> makeBindings(int vectorSize, Map<String, ExpressionType> types, LongSupplier longsFn, DoubleSupplier doublesFn, BooleanSupplier nullsFn, Supplier<String> stringFn) {
        SettableVectorInputBinding vectorBinding = new SettableVectorInputBinding(vectorSize);
        SettableObjectBinding[] objectBindings = new SettableObjectBinding[vectorSize];
        for (Map.Entry<String, ExpressionType> entry : types.entrySet()) {
            boolean[] nulls = new boolean[vectorSize];
            switch ((ExprType)entry.getValue().getType()) {
                case LONG: {
                    long[] longs = new long[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        long l = longs[i] = nulls[i] ? 0L : longsFn.getAsLong();
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding();
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : Long.valueOf(longs[i]));
                    }
                    vectorBinding.addLong(entry.getKey(), longs, nulls);
                    break;
                }
                case DOUBLE: {
                    double[] doubles = new double[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        double d = doubles[i] = nulls[i] ? 0.0 : doublesFn.getAsDouble();
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding();
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : Double.valueOf(doubles[i]));
                    }
                    vectorBinding.addDouble(entry.getKey(), doubles, nulls);
                    break;
                }
                case STRING: {
                    String[] strings = new String[vectorSize];
                    for (int i = 0; i < vectorSize; ++i) {
                        nulls[i] = nullsFn.getAsBoolean();
                        if (!nulls[i] && entry.getKey().startsWith("boolString")) {
                            strings[i] = String.valueOf(nullsFn.getAsBoolean());
                        } else {
                            String string = strings[i] = nulls[i] ? null : String.valueOf(stringFn.get());
                        }
                        if (objectBindings[i] == null) {
                            objectBindings[i] = new SettableObjectBinding();
                        }
                        objectBindings[i].withBinding(entry.getKey(), nulls[i] ? null : strings[i]);
                    }
                    vectorBinding.addString(entry.getKey(), strings);
                }
            }
        }
        return new NonnullPair((Object)objectBindings, (Object)vectorBinding);
    }

    static String[][] makeTemplateArgs(String[] arg1, String[] arg2) {
        return (String[][])Arrays.stream(arg1).flatMap(a1 -> Arrays.stream(arg2).map(a2 -> new String[]{a1, a2})).toArray(x$0 -> new String[x$0][]);
    }

    static String[][] makeTemplateArgs(String[] arg1, String[] arg2, String[] arg3) {
        return (String[][])Arrays.stream(arg1).flatMap(a1 -> Arrays.stream(arg2).flatMap(a2 -> Arrays.stream(arg3).map(a3 -> new String[]{a1, a2, a3}))).toArray(x$0 -> new String[x$0][]);
    }

    static class SettableVectorInputBinding
    implements Expr.VectorInputBinding {
        private final Map<String, boolean[]> nulls = new HashMap<String, boolean[]>();
        private final Map<String, long[]> longs = new HashMap<String, long[]>();
        private final Map<String, double[]> doubles = new HashMap<String, double[]>();
        private final Map<String, Object[]> objects = new HashMap<String, Object[]>();
        private final Map<String, ExpressionType> types = new HashMap<String, ExpressionType>();
        private final int vectorSize;
        private int id = 0;

        SettableVectorInputBinding(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        public SettableVectorInputBinding addBinding(String name, ExpressionType type, boolean[] nulls) {
            this.nulls.put(name, nulls);
            this.types.put(name, type);
            return this;
        }

        public SettableVectorInputBinding addLong(String name, long[] longs) {
            return this.addLong(name, longs, new boolean[longs.length]);
        }

        public SettableVectorInputBinding addLong(String name, long[] longs, boolean[] nulls) {
            assert (longs.length == this.vectorSize);
            this.longs.put(name, longs);
            return this.addBinding(name, ExpressionType.LONG, nulls);
        }

        public SettableVectorInputBinding addDouble(String name, double[] doubles) {
            return this.addDouble(name, doubles, new boolean[doubles.length]);
        }

        public SettableVectorInputBinding addDouble(String name, double[] doubles, boolean[] nulls) {
            assert (doubles.length == this.vectorSize);
            this.doubles.put(name, doubles);
            return this.addBinding(name, ExpressionType.DOUBLE, nulls);
        }

        public SettableVectorInputBinding addString(String name, String[] strings) {
            assert (strings.length == this.vectorSize);
            this.objects.put(name, strings);
            return this.addBinding(name, ExpressionType.STRING, new boolean[strings.length]);
        }

        public <T> T[] getObjectVector(String name) {
            return this.objects.getOrDefault(name, new Object[this.getCurrentVectorSize()]);
        }

        public ExpressionType getType(String name) {
            return this.types.get(name);
        }

        public long[] getLongVector(String name) {
            return this.longs.getOrDefault(name, new long[this.getCurrentVectorSize()]);
        }

        public double[] getDoubleVector(String name) {
            return this.doubles.getOrDefault(name, new double[this.getCurrentVectorSize()]);
        }

        @Nullable
        public boolean[] getNullVector(String name) {
            boolean[] defaultVector = new boolean[this.getCurrentVectorSize()];
            Arrays.fill(defaultVector, true);
            return this.nulls.getOrDefault(name, defaultVector);
        }

        public int getMaxVectorSize() {
            return this.vectorSize;
        }

        public int getCurrentVectorSize() {
            return this.vectorSize;
        }

        public int getCurrentVectorId() {
            return this.id++;
        }
    }
}

