/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.constant;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.RandomUtils;
import org.apache.druid.query.aggregation.constant.LongConstantBufferAggregator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongConstantBufferAggregatorTest {
    private long randomVal;
    private LongConstantBufferAggregator aggregator;
    private ByteBuffer byteBuffer;

    @Before
    public void setup() {
        this.randomVal = RandomUtils.nextLong();
        this.aggregator = new LongConstantBufferAggregator(this.randomVal);
        this.byteBuffer = null;
    }

    @Test
    public void testLong() {
        Assert.assertEquals((long)this.randomVal, (long)this.aggregator.getLong(this.byteBuffer, 0));
    }

    @Test
    public void testAggregate() {
        this.aggregator.aggregate(this.byteBuffer, 0);
        Assert.assertEquals((long)this.randomVal, (long)this.aggregator.getLong(this.byteBuffer, 0));
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((float)this.randomVal, (float)this.aggregator.getFloat(this.byteBuffer, 0), (float)1.0E-4f);
    }

    @Test
    public void testGet() {
        Assert.assertEquals((Object)this.randomVal, (Object)this.aggregator.get(this.byteBuffer, 0));
    }
}

