/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.operator.GlueingPartitioningOperator;
import org.apache.druid.query.operator.InlineScanOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorTestHelper;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.junit.Assert;
import org.junit.Test;

public class GlueingPartitioningOperatorTest {
    @Test
    public void testPartitioning() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"));
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2), RowsAndColumnsHelper.expectedSingleColumnRac(1)).runToCompletion((Operator)op);
    }

    @Test
    public void testPartitioningWithMultipleRACs() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 2, 2, 1));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"));
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2), RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2), RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2), RowsAndColumnsHelper.expectedSingleColumnRac(1)).runToCompletion((Operator)op);
    }

    @Test
    public void testPartitioningWithMultipleConcatenationBetweenRACs() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 2));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"));
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2)).runToCompletion((Operator)op);
    }

    @Test
    public void testPartitioningWithNoGlueing() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 2, 3), RowsAndColumnsHelper.makeSingleColumnRac(4, 5, 6), RowsAndColumnsHelper.makeSingleColumnRac(7, 8, 9));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"));
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1), RowsAndColumnsHelper.expectedSingleColumnRac(2), RowsAndColumnsHelper.expectedSingleColumnRac(3), RowsAndColumnsHelper.expectedSingleColumnRac(4), RowsAndColumnsHelper.expectedSingleColumnRac(5), RowsAndColumnsHelper.expectedSingleColumnRac(6), RowsAndColumnsHelper.expectedSingleColumnRac(7), RowsAndColumnsHelper.expectedSingleColumnRac(8), RowsAndColumnsHelper.expectedSingleColumnRac(9)).runToCompletion((Operator)op);
    }

    @Test
    public void testPartitioningWithNoPartitionColumns() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, Collections.emptyList());
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 2, 1)).runToCompletion((Operator)op);
    }

    @Test
    public void testMaxRowsConstraintViolation() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"), Integer.valueOf(2));
        Assert.assertThrows((String)"Too many rows to process (requested = 3, max = 2).", DruidException.class, () -> new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper[0]).runToCompletion((Operator)op));
    }

    @Test
    public void testMaxRowsConstraintViolationWhenGlueing() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.makeSingleColumnRac(1, 2, 3));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"), Integer.valueOf(3));
        Assert.assertThrows((String)"Too many rows to process (requested = 4, max = 3).", DruidException.class, () -> new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper[0]).runToCompletion((Operator)op));
    }

    @Test
    public void testMaxRowsConstraintWhenGlueing() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.makeSingleColumnRac(2, 2, 2));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"), Integer.valueOf(3));
        new OperatorTestHelper().expectRowsAndColumns(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2, 2)).runToCompletion((Operator)op);
    }

    @Test
    public void testStopMidStream() {
        InlineScanOperator inlineScanOperator = InlineScanOperator.make(RowsAndColumnsHelper.makeSingleColumnRac(1, 1, 1, 2, 2, 1));
        GlueingPartitioningOperator op = new GlueingPartitioningOperator((Operator)inlineScanOperator, (List)ImmutableList.of((Object)"column"));
        new OperatorTestHelper().expectAndStopAfter(RowsAndColumnsHelper.expectedSingleColumnRac(1, 1, 1), RowsAndColumnsHelper.expectedSingleColumnRac(2, 2)).runToCompletion((Operator)op);
    }
}

