/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.ranking.WindowCumeDistProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Assert;
import org.junit.Test;

public class WindowCumeDistProcessorTest {
    @Test
    public void testCumeDistProcessing() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("vals", new IntArrayColumn(new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        WindowCumeDistProcessor processor = new WindowCumeDistProcessor(Collections.singletonList("vals"), "CumeDist");
        Assert.assertEquals(Collections.singletonList("CumeDist"), (Object)processor.getOutputColumnNames());
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("vals", new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}).expectColumn("CumeDist", new double[]{0.1, 0.3, 0.3, 0.4, 0.5, 0.6, 0.8, 0.8, 1.0, 1.0});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

