/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.AndFilter;
import org.junit.Assert;
import org.junit.Test;

public class RowFilterPolicyTest {
    private static final RowFilterPolicy SIMPLE_ROW_POLICY = RowFilterPolicy.from((DimFilter)new EqualityFilter("col0", ColumnType.STRING, (Object)"val0", null));

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(RowFilterPolicy.class).usingGetClass().withNonnullFields(new String[]{"rowFilter"}).verify();
    }

    @Test
    public void test_deserialize_fromString() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Policy deserialized = (Policy)jsonMapper.readValue("{\"type\":\"row\",\"rowFilter\":{\"type\":\"equals\",\"column\":\"col0\",\"matchValueType\":\"STRING\",\"matchValue\":\"val0\"}}\n", Policy.class);
        Assert.assertEquals((Object)SIMPLE_ROW_POLICY, (Object)deserialized);
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Policy deserialized = (Policy)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)SIMPLE_ROW_POLICY), Policy.class);
        Assert.assertEquals((Object)SIMPLE_ROW_POLICY, (Object)deserialized);
    }

    @Test
    public void testVisit() {
        EqualityFilter policyFilter = new EqualityFilter("col", ColumnType.STRING, (Object)"val", null);
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)policyFilter);
        Assert.assertEquals((Object)policyFilter, (Object)policy.visit(CursorBuildSpec.FULL_SCAN).getFilter());
    }

    @Test
    public void testVisit_combineFilters() {
        EqualityFilter filter = new EqualityFilter("col0", ColumnType.STRING, (Object)"val0", null);
        CursorBuildSpec spec = CursorBuildSpec.builder().setFilter((Filter)filter).build();
        EqualityFilter policyFilter = new EqualityFilter("col", ColumnType.STRING, (Object)"val", null);
        RowFilterPolicy policy = RowFilterPolicy.from((DimFilter)policyFilter);
        AndFilter expected = new AndFilter((List)ImmutableList.of((Object)policyFilter.toFilter(), (Object)filter));
        Assert.assertEquals((Object)expected, (Object)policy.visit(spec).getFilter());
    }
}

